set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '143',
      '24012114',
      46,
      22,
      '3421111',
      96,
      NULL,
      1,
      2,
      '314021',
      3.164864,
      ' 5-29-1991',
      36.562206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.042957,
      1,
      3.385962,
      NULL,
      2,
      0,
      1.360005,
      0,
      0,
      1.416113,
      1.912264,
      0,
      1.177701,
      NULL,
      3.387770,
      0,
      0.540997,
      0,
      1,
      0,
      5,
      0,
      3,
      0,
      0,
      0.794380,
      NULL,
      NULL,
      1.391121,
      NULL,
      NULL,
      1.691546,
      1.275408,
      NULL,
      1.451429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.538023,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.345569,
      3,
      NULL,
      1,
      NULL,
      0.599828,
      1.072887,
      0.518826,
      0,
      0.653656,
      NULL,
      0,
      0.638635,
      0.669668,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.340965,
      0.110215,
      0,
      NULL,
      0,
      0.456478,
      2.064179,
      NULL,
      NULL,
      1,
      NULL,
      1,
      3.337451,
      1.981942,
      0,
      0.856198,
      NULL,
      2,
      2,
      0.008384,
      2.295548,
      7,
      4,
      NULL,
      5.529283,
      NULL,
      0.591187,
      NULL,
      NULL,
      5.429236,
      1.174107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.402673,
      0,
      1,
      0.623630,
      NULL,
      1.673646,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.371849,
      NULL,
      1,
      1,
      NULL,
      4,
      2.204113,
      3.163018,
      1.711448,
      NULL,
      3,
      0.609262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      5,
      4,
      1.576199,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.351226,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.237527,
      NULL,
      3.410102,
      NULL,
      0,
      2.578799,
      0,
      3.346440,
      0,
      0.357534,
      NULL,
      NULL,
      1.872598,
      0,
      1.138476,
      1.881066,
      1.859094,
      0.965835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.018802,
      NULL,
      '10313',
      '',
      0.661772,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      4,
      NULL,
      2,
      1,
      0.671887,
      2,
      3.748653,
      NULL,
      2);
commit;
end;
/


