set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '244',
      '03011440',
      13.585760,
      41,
      '3134440',
      13,
      4,
      NULL,
      2,
      '040314',
      3,
      '10-18-2002',
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.909638,
      1,
      1.724050,
      NULL,
      0.360985,
      3,
      1.158025,
      1.955689,
      1.404262,
      5,
      0.111154,
      0.131503,
      1.115989,
      1,
      1,
      3,
      0,
      1,
      NULL,
      0,
      0.565879,
      5.108811,
      0,
      NULL,
      1,
      0.682243,
      0.470273,
      NULL,
      NULL,
      1.850230,
      NULL,
      NULL,
      3,
      0,
      1.052890,
      0.994771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.662846,
      0.270217,
      1,
      0.313521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881570,
      1.042231,
      1.468318,
      5,
      NULL,
      1,
      0.201112,
      1,
      0,
      NULL,
      0.740632,
      0.504416,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.388088,
      NULL,
      1.691366,
      5.966321,
      0,
      1.200979,
      0,
      0.633383,
      5.274638,
      1,
      3,
      3.809817,
      3.570457,
      0.495531,
      0.558288,
      0,
      3,
      1.303651,
      0.897532,
      5.499947,
      1,
      0,
      NULL,
      0,
      NULL,
      7.859524,
      0.997766,
      NULL,
      3.497935,
      1.767385,
      0.655639,
      NULL,
      NULL,
      3,
      0.967283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.466458,
      0,
      0.573502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      2.273799,
      1.047935,
      0,
      1,
      NULL,
      2.919501,
      NULL,
      0,
      5,
      1.136082,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.626026,
      NULL,
      4,
      3.362436,
      1,
      1,
      3.793264,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.762711,
      1.088031,
      1,
      1,
      1.828219,
      1,
      2,
      0,
      0.928788,
      NULL,
      0,
      1,
      0,
      1.768657,
      1,
      1,
      0.122314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '2234',
      '42001',
      '',
      NULL,
      '01042',
      '',
      NULL,
      2.087639,
      NULL,
      NULL,
      '',
      2.081736,
      4.202023,
      NULL,
      0,
      3.235841,
      1,
      0,
      0,
      2.300705);
commit;
end;
/


