set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7736674';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34043303',
      NULL,
      55.598546,
      '0034324',
      NULL,
      2,
      0,
      2,
      '121303',
      1.778619,
      '10-16-1978',
      40.722174,
      12,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      0,
      0.811041,
      3,
      1.634555,
      NULL,
      0,
      5.487611,
      1.932930,
      1,
      1,
      1.237790,
      1.140308,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.432383,
      NULL,
      NULL,
      1.607748,
      1,
      1.747135,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.823264,
      1.336996,
      0,
      0.435266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958639,
      NULL,
      1,
      5,
      NULL,
      0,
      1,
      0.417399,
      1.129509,
      NULL,
      0,
      1.249887,
      1.930870,
      1,
      0.372400,
      0.951306,
      NULL,
      1,
      1.752405,
      NULL,
      0.843293,
      0,
      1,
      0.990380,
      0,
      0.672716,
      1,
      0.513796,
      3,
      1.759691,
      0,
      NULL,
      1,
      1.201022,
      2.921280,
      0.494565,
      5,
      5.431442,
      5.123454,
      2,
      NULL,
      0.301558,
      1.980116,
      2,
      5,
      5,
      1.609823,
      2,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.358546,
      0,
      1,
      1,
      1.034141,
      1.415733,
      0.684884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077135,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.299463,
      0.873860,
      NULL,
      NULL,
      NULL,
      1,
      0.789954,
      NULL,
      6.784751,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823719,
      3.891242,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937127,
      1.306183,
      2.766906,
      1,
      1,
      3.289787,
      1,
      2,
      1,
      3,
      0,
      1,
      0,
      1,
      1.708422,
      NULL,
      0,
      0,
      0,
      0.231102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.574851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      '4211',
      '14042',
      '',
      2.786168,
      '12310',
      '',
      NULL,
      0.495324,
      '1003',
      '2321',
      '',
      1.826570,
      0.703329,
      3.115776,
      NULL,
      2.932428,
      4,
      1.612762,
      3.384394,
      1.789766);
commit;
end;
/


