set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '022',
      '24024411',
      35.025797,
      15,
      '2442331',
      61,
      5,
      1,
      3,
      '010140',
      3,
      ' 8-15-1991',
      16,
      18,
      1,
      NULL,
      0.190632,
      1.429403,
      NULL,
      1,
      1,
      0.648381,
      1.421235,
      3,
      0.625617,
      0.488377,
      3.523235,
      1.128114,
      NULL,
      1.277226,
      0.355362,
      0.702993,
      0.594181,
      1,
      0,
      1.121385,
      1.012636,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.209043,
      1.867623,
      NULL,
      NULL,
      1.387866,
      NULL,
      NULL,
      3.832854,
      0,
      0.016925,
      1,
      2.409419,
      3,
      0,
      0,
      0.547043,
      1.385553,
      0,
      NULL,
      NULL,
      0.943979,
      0,
      2.513366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.633664,
      NULL,
      NULL,
      0.511218,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105433,
      0,
      1,
      1.157805,
      0.947741,
      0.869050,
      1.999500,
      NULL,
      0,
      0,
      0.161272,
      1,
      1.907393,
      1.724823,
      NULL,
      0.607021,
      NULL,
      1.287360,
      1.033429,
      0,
      1.028955,
      1,
      1.103081,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.155645,
      NULL,
      4.908733,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      3,
      3.252104,
      0.004263,
      5,
      0.609334,
      NULL,
      NULL,
      9,
      0.612695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.015743,
      1,
      0,
      NULL,
      0.829058,
      NULL,
      0,
      0.334407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529910,
      NULL,
      1.468374,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.104774,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.935341,
      3.532063,
      1,
      1.561545,
      0,
      3.267597,
      1,
      1.258483,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0.169545,
      1.095124,
      NULL,
      1,
      0.839142,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '01214',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      3.857327,
      1.136817,
      4.224130,
      NULL,
      1,
      NULL,
      NULL);
commit;
end;
/


