set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      7.647177,
      21.120584,
      NULL,
      74,
      3,
      2.813058,
      3,
      '413300',
      4.900474,
      NULL,
      63.450190,
      11,
      0.899784,
      NULL,
      1,
      0.688448,
      2.465939,
      0,
      0,
      1.014691,
      0,
      2,
      NULL,
      NULL,
      3,
      1,
      1.053032,
      0.121409,
      1.894410,
      0,
      NULL,
      0,
      0.300693,
      1,
      1,
      0.739762,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126205,
      0.822165,
      2,
      0,
      NULL,
      3.057213,
      2,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      1.986943,
      3.565443,
      2.904747,
      1,
      0,
      1.723494,
      0.367507,
      3.749233,
      0,
      0,
      0.607559,
      1,
      NULL,
      NULL,
      0.588774,
      NULL,
      NULL,
      NULL,
      NULL,
      1.547097,
      1,
      1,
      NULL,
      NULL,
      0.944403,
      1,
      0.785749,
      0.275859,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      0.559171,
      NULL,
      NULL,
      NULL,
      0.620061,
      0.466204,
      1.619493,
      1,
      0,
      2.554979,
      NULL,
      NULL,
      NULL,
      NULL,
      0.448472,
      NULL,
      NULL,
      NULL,
      0,
      0.500855,
      0.199991,
      4,
      2,
      4,
      3,
      4.080162,
      4,
      NULL,
      0,
      NULL,
      0.980694,
      NULL,
      NULL,
      6.276081,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.525761,
      1,
      1,
      0,
      1,
      1.336053,
      1.639441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416230,
      NULL,
      NULL,
      NULL,
      NULL,
      4.061461,
      0,
      NULL,
      0.338082,
      3.367022,
      2,
      NULL,
      3.005383,
      NULL,
      NULL,
      NULL,
      NULL,
      0.185545,
      1.174562,
      0.117020,
      2.520717,
      0.900338,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.170633,
      1.398973,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268638,
      NULL,
      2,
      NULL,
      NULL,
      0.299586,
      NULL,
      0.425912,
      0,
      2.852772,
      0,
      1,
      0.297604,
      NULL,
      0.626566,
      NULL,
      0,
      0,
      1.949831,
      1.071353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '41032',
      NULL,
      '33231',
      1.086944,
      '',
      '',
      NULL,
      2.591277,
      '1333',
      '',
      '',
      0,
      1.930667,
      3,
      5.876461,
      3,
      0.809466,
      3.240835,
      2.038590,
      0.214623);
commit;
end;
/


