set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '21213303',
      8,
      15.287459,
      '4241003',
      160,
      3,
      3.107998,
      NULL,
      '042401',
      6.048664,
      NULL,
      31,
      15.264304,
      0,
      NULL,
      1.399488,
      NULL,
      1,
      0,
      1.753692,
      1.200541,
      1,
      0,
      NULL,
      0.163336,
      0.732885,
      0.812126,
      1.771572,
      1,
      2,
      1,
      2.838981,
      0,
      1.488162,
      1.560078,
      0,
      0.955986,
      4,
      NULL,
      0.694630,
      1.347737,
      1,
      0.759233,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.058796,
      1.102631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.547194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154991,
      0.952795,
      0.317310,
      1,
      0,
      1.255048,
      0,
      NULL,
      0,
      0.934674,
      0,
      1,
      0.924621,
      0,
      1,
      NULL,
      0.168202,
      NULL,
      1,
      NULL,
      1.197439,
      0,
      1,
      1,
      NULL,
      NULL,
      0.859423,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.981557,
      1,
      0,
      NULL,
      NULL,
      3,
      7,
      2.976551,
      11,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      2,
      0.468545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.748860,
      0,
      0,
      0.074064,
      0.031869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.409232,
      NULL,
      NULL,
      0,
      0.672115,
      1.173496,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.455320,
      NULL,
      NULL,
      3,
      0,
      1,
      0.119072,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508940,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.605301,
      2.689617,
      NULL,
      2,
      0,
      2.551009,
      1.147064,
      0.144127,
      2.674417,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.596301,
      1.668593,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722840,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7,
      '31100',
      '33444',
      NULL,
      1,
      '',
      NULL,
      NULL,
      3.411785,
      '0322',
      '30122',
      '',
      5,
      3,
      1.194638,
      1.933658,
      3.420648,
      3.081439,
      NULL,
      0.650886,
      3.057252);
commit;
end;
/


