set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      '33304034',
      72,
      26.421533,
      '0421133',
      NULL,
      0,
      2,
      3,
      NULL,
      4,
      ' 6- 3-1999',
      22.836414,
      25.512020,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      2,
      2,
      3.509610,
      0,
      NULL,
      3,
      NULL,
      0,
      1.297249,
      1.847281,
      1,
      5.395841,
      1.523066,
      NULL,
      1.063598,
      1.495726,
      1.736560,
      5,
      0,
      2.859296,
      NULL,
      0,
      1.036778,
      NULL,
      NULL,
      1.037130,
      NULL,
      NULL,
      NULL,
      0,
      1.647531,
      3,
      NULL,
      1,
      1.043083,
      0,
      1,
      NULL,
      0.992980,
      NULL,
      1.040994,
      2.727773,
      0.713891,
      2.877770,
      3,
      NULL,
      1.583561,
      0.754920,
      0,
      0,
      2,
      0,
      2,
      1,
      1.974020,
      NULL,
      NULL,
      0.556240,
      NULL,
      NULL,
      NULL,
      1.190077,
      1,
      0.951374,
      0.256513,
      NULL,
      1,
      0.445409,
      0,
      NULL,
      1.168502,
      1.299893,
      1.354134,
      NULL,
      0.382441,
      0,
      1,
      NULL,
      1.931511,
      NULL,
      NULL,
      1.577237,
      NULL,
      1,
      1,
      1,
      0.635096,
      0,
      0.396858,
      0.336378,
      0.374259,
      1.201974,
      0,
      NULL,
      0.682144,
      1.176018,
      0,
      6,
      NULL,
      4,
      8.558184,
      10.249001,
      3.379539,
      6.845131,
      6.118975,
      0.464256,
      0.088193,
      NULL,
      NULL,
      NULL,
      NULL,
      9.491420,
      1.137365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.188868,
      0.419845,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.686529,
      0,
      1.037059,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.256829,
      1.937976,
      1,
      2.135165,
      3.867079,
      1,
      0.149651,
      NULL,
      NULL,
      NULL,
      0.897063,
      3.056413,
      1.448380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566757,
      2.440522,
      NULL,
      2,
      0.422042,
      0.696357,
      3,
      0,
      1.532637,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.009701,
      0.204248,
      0,
      1.577717,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '01142',
      '21140',
      '33334',
      NULL,
      '',
      '',
      '',
      NULL,
      '0121',
      NULL,
      '',
      2,
      1,
      1,
      1,
      0.444851,
      3,
      3.802861,
      1.359180,
      0);
commit;
end;
/


