set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1111',
      NULL,
      38.860382,
      30.754238,
      '3011144',
      17.906503,
      0,
      2,
      NULL,
      '113243',
      2,
      ' 2- 8-1984',
      56,
      29.931104,
      0,
      NULL,
      0.347952,
      0,
      2.967587,
      NULL,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      5.127255,
      NULL,
      2,
      NULL,
      NULL,
      1.593970,
      0,
      0.238553,
      0,
      1.598559,
      3.645657,
      1,
      0.128447,
      0,
      0.331251,
      1.063627,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      5.551558,
      1.174437,
      3.557678,
      2.012922,
      1,
      3,
      3,
      2,
      NULL,
      3,
      3.190461,
      0.089160,
      1.357206,
      1,
      NULL,
      0.227952,
      NULL,
      3.158534,
      1.165089,
      0.861078,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.116159,
      NULL,
      NULL,
      1,
      0,
      1,
      0.852647,
      1,
      1,
      0.239385,
      1,
      1.440800,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      1,
      0.544348,
      1.663337,
      1,
      NULL,
      0.613004,
      1.223845,
      1,
      0,
      0,
      0,
      0,
      1.481682,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500593,
      0.446979,
      NULL,
      0,
      1.262568,
      NULL,
      0.990376,
      7,
      2,
      3.842592,
      NULL,
      NULL,
      5.991018,
      NULL,
      1.719117,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.773792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      1.053031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014911,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.436956,
      0,
      1.774626,
      0,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.906799,
      NULL,
      4.934563,
      2.586401,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847227,
      0.911662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011817,
      NULL,
      0.210183,
      NULL,
      0.871688,
      0,
      0.107434,
      1,
      1.885054,
      1,
      1.523392,
      0.528161,
      0.373294,
      0.839976,
      0,
      0,
      1.597835,
      1.285014,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.615435,
      NULL,
      '43231',
      '34044',
      1.730515,
      '',
      '',
      '',
      3,
      '01104',
      '0321',
      '',
      1,
      2,
      0,
      NULL,
      3,
      3,
      3,
      NULL,
      2.853466);
commit;
end;
/


