set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9501630';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1004',
      '24423310',
      NULL,
      41,
      '2320004',
      NULL,
      NULL,
      1.979018,
      3,
      '010344',
      5.940866,
      ' 2-26-1998',
      5,
      33.078485,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.794063,
      NULL,
      3,
      NULL,
      0.456030,
      0.773039,
      5,
      0.117645,
      2.553322,
      1,
      2,
      NULL,
      5,
      0,
      0.103833,
      0,
      1.088285,
      1,
      NULL,
      NULL,
      3.020484,
      NULL,
      1.355763,
      0,
      NULL,
      NULL,
      1.605755,
      NULL,
      NULL,
      6.390956,
      NULL,
      NULL,
      0,
      0,
      0.035077,
      0,
      1.389275,
      1.531995,
      0,
      2,
      3,
      0.775211,
      NULL,
      0.135994,
      1,
      2.445217,
      1.703779,
      2.131929,
      1.818567,
      1.548122,
      0,
      NULL,
      NULL,
      0,
      1.188705,
      1,
      NULL,
      NULL,
      0.362765,
      NULL,
      NULL,
      0.257331,
      1.934249,
      1.348814,
      0.118828,
      1.591960,
      NULL,
      3.059830,
      0,
      NULL,
      3.074039,
      5,
      NULL,
      1.423064,
      3.057386,
      0.212302,
      1.230691,
      NULL,
      1,
      0.565307,
      NULL,
      0.780455,
      1.769743,
      1,
      1,
      1.123439,
      1,
      0,
      1.801351,
      1,
      NULL,
      1.331887,
      1.694510,
      NULL,
      NULL,
      NULL,
      1,
      0.688100,
      5.138557,
      5.114664,
      5,
      6,
      2,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      0.907174,
      NULL,
      NULL,
      NULL,
      0.661972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1.558459,
      1,
      1.477002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685942,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.579214,
      0.718717,
      0.739133,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026565,
      3.075805,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.503603,
      0.769497,
      0,
      2.242823,
      1.394643,
      3,
      1.207634,
      0,
      0,
      1,
      1.924236,
      0.746804,
      0.992292,
      1.653026,
      0.856718,
      NULL,
      1.635553,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.465835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.383990,
      '22002',
      '32412',
      '00032',
      0.597126,
      '',
      '',
      '',
      5.679069,
      NULL,
      '1001',
      '',
      0,
      1.018921,
      3.484061,
      2.661967,
      3.931479,
      3.028153,
      3.398789,
      2.487960,
      NULL);
commit;
end;
/


