set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9318626';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '3311120',
      13.161108,
      4,
      0,
      2,
      NULL,
      0.676183,
      '10-10-2002',
      10,
      NULL,
      0.427998,
      NULL,
      0,
      1,
      2,
      1.018086,
      0,
      0,
      0,
      1.506629,
      NULL,
      1.709305,
      0,
      0,
      0.004246,
      0.975445,
      1,
      1,
      0.673569,
      1,
      1,
      1,
      0.686407,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.751259,
      4,
      1,
      0.865620,
      1,
      1.203182,
      3,
      1.723557,
      0.072381,
      0,
      0,
      NULL,
      2.511582,
      0.009952,
      3,
      NULL,
      NULL,
      3,
      1.567613,
      NULL,
      1.864545,
      0.379775,
      0,
      NULL,
      3.066888,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.795734,
      1.273062,
      1,
      1.251009,
      3.507632,
      0.559138,
      1.390425,
      NULL,
      1,
      1.753121,
      1.197962,
      NULL,
      NULL,
      0.237522,
      NULL,
      NULL,
      0,
      0.332748,
      0.992823,
      NULL,
      1,
      1.734592,
      0.019692,
      0.639127,
      0.896784,
      1.546780,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.252042,
      0,
      0,
      2,
      NULL,
      7.031228,
      4.006254,
      5.954153,
      1,
      4.295366,
      NULL,
      4.166821,
      0.681780,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.406288,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      1.977498,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.011537,
      0.406430,
      NULL,
      NULL,
      0,
      0,
      1.368935,
      0,
      1,
      0.012718,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811436,
      5.901240,
      0,
      0,
      2,
      5.253617,
      1.079201,
      NULL,
      NULL,
      0.289133,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.938543,
      0.168047,
      1.266946,
      3.383945,
      NULL,
      1.556260,
      1,
      0.136890,
      2,
      1,
      1.017772,
      NULL,
      1,
      1,
      0,
      0.378466,
      0.876451,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741895,
      0.062277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.654002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.589647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.393031,
      1,
      NULL,
      '24144',
      '',
      '',
      3.144584,
      '21241',
      '',
      '',
      1.746640,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


