set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9318626';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '1',
      NULL,
      NULL,
      '1030220',
      NULL,
      NULL,
      NULL,
      1,
      '033340',
      3,
      NULL,
      39,
      NULL,
      0,
      NULL,
      0,
      0.448309,
      1,
      1.285157,
      NULL,
      NULL,
      1.277134,
      1.793381,
      0.971309,
      0.754595,
      2,
      NULL,
      0.951636,
      0.364286,
      3.290579,
      0,
      0.042927,
      0.011109,
      NULL,
      0.716701,
      1,
      0.027663,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.492639,
      2,
      0,
      NULL,
      NULL,
      1,
      2,
      1.646782,
      3.889011,
      0,
      NULL,
      1.456218,
      0.800380,
      1,
      2.098742,
      2.579757,
      0.447224,
      1.874284,
      0,
      1.845463,
      0.261157,
      1.729236,
      NULL,
      0,
      NULL,
      NULL,
      0.605385,
      NULL,
      NULL,
      1.836188,
      NULL,
      NULL,
      3.844301,
      0.555643,
      3.865921,
      NULL,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      0.139402,
      1,
      1.985999,
      1,
      1.976180,
      1.377475,
      1,
      NULL,
      NULL,
      0,
      0,
      1.341996,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      5,
      8.020475,
      5,
      NULL,
      1,
      5.073011,
      6,
      2,
      5.777295,
      NULL,
      NULL,
      1,
      1.879517,
      NULL,
      NULL,
      0.925473,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630332,
      1.207754,
      2,
      1,
      0,
      0,
      1.121593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.055985,
      2,
      1.621004,
      1.019040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219811,
      2,
      3,
      1.444687,
      NULL,
      5.807777,
      0.556200,
      4.583984,
      5.568112,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0.452021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.840675,
      2.140431,
      NULL,
      NULL,
      NULL,
      NULL,
      3.727220,
      3,
      1,
      1,
      0.061470,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.962169,
      '43243',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.350631,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


