set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      '13',
      29,
      14,
      '0122304',
      36.700213,
      4,
      3,
      0,
      NULL,
      NULL,
      '10-16-1999',
      38.313524,
      52.157709,
      1,
      NULL,
      1.601075,
      NULL,
      1,
      0.300988,
      NULL,
      1.716331,
      1,
      NULL,
      NULL,
      0.088489,
      NULL,
      NULL,
      NULL,
      0.680036,
      1.163662,
      NULL,
      3.380526,
      NULL,
      1.946766,
      NULL,
      1,
      0.745897,
      5,
      0,
      1.125347,
      1,
      1,
      1,
      NULL,
      NULL,
      0.865267,
      NULL,
      0.674193,
      NULL,
      0.070517,
      NULL,
      0.324630,
      NULL,
      1,
      0,
      0.574256,
      0.471927,
      1.681398,
      0,
      1,
      0.374950,
      1.173572,
      NULL,
      0.037702,
      0,
      1.214420,
      1,
      0.965576,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.404508,
      0.664896,
      1,
      1,
      1,
      1,
      0.561064,
      1.267966,
      NULL,
      0,
      NULL,
      0.789082,
      0.850840,
      0,
      0.587438,
      1,
      0,
      1,
      0,
      1.129471,
      0.577551,
      NULL,
      1.279366,
      0.752308,
      0,
      0.047468,
      1.574288,
      1.270856,
      3,
      NULL,
      3.643800,
      NULL,
      0,
      5.354985,
      0.458619,
      NULL,
      NULL,
      1.244844,
      5.318836,
      NULL,
      NULL,
      2,
      NULL,
      6,
      NULL,
      6.451283,
      6,
      3.682574,
      1.785896,
      1.939488,
      0.014494,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1.886062,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.154897,
      NULL,
      2,
      2.188417,
      NULL,
      0,
      3,
      1.400842,
      1,
      0.464060,
      NULL,
      NULL,
      NULL,
      3,
      3.651880,
      NULL,
      0.797886,
      1.264837,
      0.546552,
      7,
      7.819224,
      4.324796,
      0,
      NULL,
      0,
      NULL,
      NULL,
      3,
      11.104219,
      NULL,
      2.452040,
      1,
      0,
      7,
      5.267203,
      1,
      1.776284,
      0.769656,
      3.931289,
      NULL,
      NULL,
      0.432599,
      2,
      3,
      0.372761,
      NULL,
      1,
      0.099116,
      NULL,
      1,
      0,
      0.162856,
      1.311059,
      0,
      1,
      0.015695,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      '32014',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      '2234',
      '',
      '',
      0.958793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


