set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      NULL,
      6,
      13.658589,
      '4400022',
      NULL,
      0,
      NULL,
      1,
      '142314',
      5,
      ' 6- 9-1974',
      51.362088,
      30.566127,
      0,
      NULL,
      1,
      0,
      1.603962,
      1,
      1.294945,
      1.701397,
      0,
      0.825332,
      0.306041,
      0,
      1.599972,
      0,
      0.063445,
      1.835362,
      0,
      0.543864,
      NULL,
      0.356467,
      1,
      1.102951,
      1.571619,
      1.524618,
      1.370114,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3.492316,
      0,
      1,
      NULL,
      1,
      1.545343,
      1,
      1,
      1,
      0,
      NULL,
      1,
      0.047808,
      3,
      0.291506,
      1,
      1.442708,
      0,
      0.767254,
      NULL,
      0,
      0.975618,
      4.739433,
      1,
      0,
      1,
      1.079413,
      NULL,
      NULL,
      1.576070,
      1,
      2,
      0,
      1,
      1,
      0.239800,
      NULL,
      0.405068,
      NULL,
      1.990706,
      NULL,
      1,
      0.642724,
      0.432450,
      0.263745,
      0.576498,
      1.271927,
      1.929120,
      1,
      0.934429,
      0,
      NULL,
      0,
      2.005784,
      0,
      1.826800,
      0.402611,
      NULL,
      2.999993,
      NULL,
      1,
      1,
      1.895519,
      0.337215,
      1,
      NULL,
      4.326355,
      1.235051,
      1.124343,
      NULL,
      2.157547,
      2,
      9,
      7,
      NULL,
      4,
      7.547959,
      NULL,
      2.447906,
      5,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.342014,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8,
      0.625989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462396,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      2.761874,
      NULL,
      2,
      1.790450,
      0,
      7.687208,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.605436,
      4,
      4,
      6.771207,
      7.364888,
      0,
      0,
      1,
      3.494891,
      3.481976,
      2.831395,
      NULL,
      1,
      2,
      1.212641,
      0.969635,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0.164042,
      1.174654,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.574168,
      '11400',
      '',
      '',
      0.265763,
      '',
      '',
      NULL,
      1.635286,
      '3122',
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


