set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '40',
      40.653569,
      10.946076,
      '3010224',
      NULL,
      2,
      0.516540,
      0,
      '420313',
      3,
      ' 1-15-1998',
      NULL,
      NULL,
      1.825595,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.166988,
      1,
      1.772284,
      2,
      1,
      NULL,
      NULL,
      0,
      1.492306,
      1.060079,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1.056465,
      NULL,
      NULL,
      1.181965,
      NULL,
      NULL,
      7,
      NULL,
      1,
      2.310212,
      NULL,
      1,
      NULL,
      0,
      1.416429,
      NULL,
      1.543470,
      1,
      0,
      0.403203,
      2.085795,
      1.893464,
      NULL,
      NULL,
      1.456174,
      0,
      0,
      0,
      NULL,
      1,
      2,
      0.822840,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.547531,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229746,
      1,
      0,
      1.452252,
      0.234570,
      NULL,
      0.372406,
      NULL,
      0.671658,
      NULL,
      0.283912,
      1,
      1,
      0.318607,
      NULL,
      1,
      1.828188,
      0,
      1,
      1.760884,
      1.930198,
      NULL,
      1,
      6,
      3.215214,
      5,
      1.564189,
      1.757247,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      5,
      1,
      3,
      0.017670,
      0.975190,
      3.025803,
      0.062698,
      9,
      4.437719,
      NULL,
      NULL,
      NULL,
      0.703596,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1.560585,
      1,
      0.751965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.535118,
      NULL,
      1.817341,
      1,
      3,
      6.815596,
      NULL,
      3.377182,
      1.919485,
      0,
      3,
      NULL,
      0,
      0.068598,
      NULL,
      NULL,
      NULL,
      0,
      1,
      8.453494,
      11,
      NULL,
      0,
      3.156926,
      1,
      NULL,
      NULL,
      0,
      5.124288,
      1.875901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.633876,
      NULL,
      2.932795,
      0,
      1,
      0,
      0,
      3,
      2.501042,
      1.343363,
      0,
      0.520964,
      1.702346,
      1,
      1.977504,
      1.625241,
      1.877135,
      1.216752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '3441',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


