set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-9-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '10',
      30.202383,
      5.076642,
      '3442124',
      16,
      NULL,
      1,
      0,
      '423340',
      1,
      '11- 1-1976',
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      1.751409,
      0.925114,
      0,
      1,
      0.488617,
      4.988913,
      0.749642,
      0,
      1.522523,
      0.306768,
      1.198910,
      NULL,
      0,
      0.990105,
      NULL,
      0,
      1,
      1.967164,
      0,
      NULL,
      1.025414,
      1,
      0.594801,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.314919,
      0.090797,
      0.069316,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.619016,
      3.865441,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.994416,
      NULL,
      NULL,
      0.699966,
      NULL,
      0,
      1.682421,
      0.354112,
      0,
      0,
      NULL,
      0,
      1,
      0.167740,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      1,
      1.064256,
      NULL,
      NULL,
      NULL,
      0.361017,
      1,
      NULL,
      1.561722,
      1,
      1.458328,
      NULL,
      0,
      0.294883,
      0,
      1.287749,
      1.827867,
      7,
      0,
      5.096462,
      NULL,
      8,
      NULL,
      6,
      0.431672,
      2,
      2.943055,
      9.909660,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      2,
      1.946569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.135198,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.754883,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      6.154946,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.095571,
      2,
      1.253607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029977,
      0,
      3.239372,
      1,
      0.933616,
      1.398605,
      0,
      0.636295,
      0.695134,
      0,
      0.367448,
      0.286545,
      1.960302,
      1.885428,
      1.416392,
      1.718257,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '30224',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      3.615061,
      '2241',
      NULL,
      '',
      0.664168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


