set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '211',
      '31',
      44.047274,
      NULL,
      '0341332',
      13,
      6,
      NULL,
      NULL,
      '121304',
      4,
      '10-11-1997',
      42,
      62,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1.652687,
      1,
      0,
      0.627937,
      NULL,
      NULL,
      0.331519,
      NULL,
      NULL,
      1.578185,
      NULL,
      2.593411,
      0.129408,
      0,
      1.887564,
      NULL,
      1,
      2.093665,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.170789,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      2.341140,
      NULL,
      NULL,
      2.628820,
      NULL,
      NULL,
      3.234455,
      1,
      0.579465,
      1.306843,
      2.128109,
      3,
      1.206033,
      3.482288,
      1.929860,
      1,
      0,
      0.257266,
      1,
      3,
      0,
      1,
      0,
      1.998140,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.509091,
      NULL,
      1,
      NULL,
      1,
      1.953096,
      NULL,
      0.579450,
      1.870620,
      1,
      NULL,
      1.483805,
      1.956912,
      1,
      0.565290,
      1.310363,
      1.591860,
      NULL,
      1,
      NULL,
      0.922251,
      1,
      1,
      NULL,
      NULL,
      1.141507,
      5,
      NULL,
      1,
      NULL,
      4,
      4,
      0,
      0,
      4,
      0,
      2.110708,
      NULL,
      8.098809,
      3.248832,
      7.414766,
      4,
      1,
      NULL,
      7,
      NULL,
      2.781779,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.930104,
      1,
      0,
      1.465211,
      0,
      NULL,
      0.297447,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.879173,
      NULL,
      6.091554,
      2,
      1.354113,
      0.196971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070653,
      2.868783,
      7.627290,
      7.922431,
      NULL,
      0,
      4.224100,
      0.845339,
      NULL,
      NULL,
      1.585843,
      7.180584,
      1.748301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.386698,
      2,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      3,
      0.718594,
      1.547994,
      0,
      NULL,
      1.170462,
      1,
      1.050077,
      1.147948,
      1.671477,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '22410',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2,
      NULL,
      '41223',
      '',
      NULL,
      4,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      3.543029);
commit;
end;
/


