set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '144',
      '01100402',
      4.823450,
      37.510874,
      '3403340',
      72.830062,
      3,
      0,
      NULL,
      '022341',
      3.458591,
      ' 7-17-1983',
      31,
      41,
      0,
      NULL,
      0,
      NULL,
      0,
      1.026460,
      1,
      1,
      0,
      0,
      1,
      1.441859,
      2,
      1.843549,
      1.707154,
      NULL,
      0,
      1.572470,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      0,
      2.382331,
      0.580724,
      NULL,
      0.322259,
      NULL,
      NULL,
      1.975533,
      NULL,
      NULL,
      3.018565,
      1.334138,
      1.955909,
      0.246452,
      0.407938,
      0,
      2,
      0,
      0,
      1,
      1,
      1.010994,
      NULL,
      0,
      0,
      0.115867,
      0,
      1.962211,
      0.188819,
      0,
      0.164093,
      1.979336,
      NULL,
      0,
      0,
      0.170998,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.141503,
      1,
      1,
      NULL,
      1.365097,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1.536563,
      0,
      1.891033,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0.473617,
      NULL,
      5,
      NULL,
      6,
      3,
      2.785426,
      0.620358,
      1.624328,
      1,
      6.863220,
      0,
      3.160484,
      NULL,
      10.471733,
      8,
      NULL,
      4,
      1,
      11,
      3.333354,
      1,
      5,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.172913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      0.716422,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.022706,
      0.812371,
      2.989786,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.212809,
      3,
      0,
      0.968297,
      5,
      NULL,
      1.770569,
      0.441964,
      NULL,
      NULL,
      1,
      6,
      0.101237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749556,
      2.358282,
      0.603838,
      NULL,
      0,
      0,
      0.339864,
      NULL,
      0,
      0.066489,
      1.694032,
      1,
      NULL,
      0.163698,
      1,
      1.344574,
      NULL,
      0,
      1.918370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.536463,
      '1111',
      '11234',
      '',
      2,
      5.277100,
      3.259947,
      NULL,
      NULL,
      5.997517,
      3.787872,
      3,
      1.818632);
commit;
end;
/


