set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '400',
      '1',
      22,
      NULL,
      '0224220',
      71,
      1,
      2.127828,
      1,
      '212412',
      1,
      '11-28-1984',
      19.092519,
      47,
      1.011356,
      NULL,
      NULL,
      NULL,
      0.487903,
      1,
      0,
      1,
      2,
      0,
      1,
      1.600504,
      4,
      1,
      0.882283,
      1.449144,
      0,
      NULL,
      4,
      NULL,
      1,
      NULL,
      0.135333,
      0,
      NULL,
      1,
      1.726222,
      0.002589,
      0,
      1.764305,
      NULL,
      NULL,
      0.517229,
      NULL,
      NULL,
      4,
      1,
      1,
      3.644964,
      0,
      0,
      0.231967,
      NULL,
      1.696661,
      1.999831,
      0,
      1.671934,
      0.318768,
      1,
      0,
      1.785655,
      3,
      0,
      1,
      0.148453,
      1.934866,
      0.268327,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.348482,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341338,
      NULL,
      1.053119,
      0,
      1.868632,
      0.459493,
      0.018893,
      0.133410,
      0.199665,
      0.424527,
      NULL,
      NULL,
      NULL,
      1.466362,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.228616,
      0,
      0,
      1.832951,
      3,
      4,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7,
      6,
      NULL,
      5.482529,
      9.517644,
      NULL,
      1.235313,
      0.257555,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1.428986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1.910420,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.082028,
      NULL,
      3.918027,
      2,
      0.375313,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.611928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.714209,
      1,
      NULL,
      NULL,
      5,
      1,
      1.596820,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494307,
      1,
      3,
      2.197707,
      2,
      1.809621,
      1,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.089484,
      1,
      NULL,
      1.505970,
      1,
      0,
      0.441243,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.872389,
      '04000',
      '',
      '',
      0.883108,
      '',
      '',
      '',
      5.254405,
      '2313',
      '42034',
      '2141',
      NULL,
      3.749637,
      3,
      0,
      2.842920,
      NULL,
      3.387041,
      NULL,
      2.581135);
commit;
end;
/


