set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '031',
      '01120342',
      19.743925,
      71.729483,
      NULL,
      38.372885,
      NULL,
      2,
      1,
      '310303',
      3,
      ' 3- 0-1997',
      NULL,
      17.046759,
      1,
      NULL,
      NULL,
      0.691975,
      2.968109,
      1,
      0.960221,
      0,
      2.240104,
      0,
      0.643229,
      1.642241,
      2,
      1.908254,
      0,
      3.580948,
      1.414277,
      0,
      5.141928,
      1.470862,
      0.208084,
      NULL,
      1,
      0.803946,
      1.048294,
      0,
      4,
      1.755607,
      0,
      1,
      NULL,
      NULL,
      1.744735,
      NULL,
      NULL,
      1,
      0,
      1,
      0.295114,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1.036518,
      3,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644089,
      0.890617,
      0.964723,
      0.480090,
      1,
      NULL,
      1,
      1.275637,
      1,
      0.794294,
      NULL,
      2.156093,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.720101,
      NULL,
      1.514843,
      NULL,
      1.987914,
      0.264432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.617058,
      2.263376,
      NULL,
      5.706385,
      0.697671,
      3.041555,
      8.705457,
      0.257600,
      3.887831,
      0,
      7.445404,
      0,
      1.688811,
      NULL,
      3,
      0.694923,
      NULL,
      NULL,
      4,
      0.654002,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.627937,
      NULL,
      2,
      1,
      0.514762,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      2.630066,
      1.532959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.402615,
      6,
      NULL,
      1.481937,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.921693,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.623104,
      NULL,
      0.462085,
      NULL,
      3,
      NULL,
      1.821566,
      NULL,
      1.906893,
      0.294185,
      1.023417,
      1.450053,
      0,
      0,
      1.928932,
      1,
      0.229640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.261664,
      '23434',
      '',
      '',
      1.824060,
      '',
      '',
      '',
      NULL,
      NULL,
      '00411',
      '1024',
      4.864037,
      0,
      0.528642,
      3.278604,
      1.595040,
      1.085685,
      3.205795,
      NULL,
      NULL);
commit;
end;
/


