set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '220',
      '02122202',
      5.118101,
      50.562604,
      NULL,
      17.623666,
      0,
      0,
      1,
      '444131',
      NULL,
      NULL,
      40,
      NULL,
      NULL,
      NULL,
      0,
      1.146137,
      1.948722,
      0.485151,
      0,
      0,
      0,
      1,
      1,
      0,
      4.841362,
      1,
      0.148312,
      0,
      1,
      1.319444,
      2,
      0,
      NULL,
      0.041532,
      NULL,
      1.409340,
      2.292639,
      0,
      NULL,
      1,
      NULL,
      0.419461,
      NULL,
      NULL,
      1.274248,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904709,
      NULL,
      1.682835,
      2,
      1,
      2,
      NULL,
      1.920111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.430779,
      NULL,
      1,
      1,
      1.515911,
      NULL,
      NULL,
      1.072101,
      1,
      1,
      1.585695,
      NULL,
      1.148740,
      1,
      NULL,
      0.775227,
      1.616421,
      NULL,
      0,
      1,
      0.156519,
      1,
      NULL,
      2.591387,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1.352806,
      2,
      NULL,
      NULL,
      6.454439,
      9.748125,
      NULL,
      1.417267,
      10.047274,
      4.233151,
      1.324726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.203258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144252,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.699803,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.149046,
      NULL,
      1.690203,
      1.377209,
      1.336289,
      5.884232,
      2.201841,
      0.869693,
      1.213428,
      1,
      5.962929,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.844955,
      3.786534,
      4,
      5,
      6,
      1,
      3.805790,
      NULL,
      NULL,
      NULL,
      NULL,
      10.726252,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207281,
      1,
      3.641483,
      2.810118,
      3,
      0.443758,
      1,
      3.789357,
      1.775153,
      0,
      0,
      0,
      1.206230,
      0,
      0.069476,
      NULL,
      NULL,
      1,
      0.572812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '42312',
      NULL,
      '',
      1.029545,
      '',
      '',
      '',
      4,
      '2120',
      '32131',
      '4421',
      1.500261,
      0.554336,
      NULL,
      2.797279,
      1,
      2.085779,
      0.351262,
      2,
      3);
commit;
end;
/


