set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-10-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '000',
      '23114201',
      NULL,
      36,
      '2013232',
      178.200577,
      4,
      1.442397,
      3,
      NULL,
      2.258501,
      ' 8- 2-1990',
      10.383571,
      NULL,
      1.206326,
      NULL,
      0.872464,
      NULL,
      1,
      0,
      0.110777,
      NULL,
      2,
      0,
      0.462541,
      0,
      5,
      NULL,
      1,
      0,
      0,
      0,
      4.628952,
      NULL,
      1,
      0,
      0.236165,
      1,
      5.946173,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1.018594,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      1,
      1,
      0,
      2.188758,
      NULL,
      0,
      1,
      0.376523,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2.841891,
      5.532777,
      0,
      0,
      2,
      NULL,
      0.464719,
      NULL,
      NULL,
      0.781714,
      NULL,
      NULL,
      0.453890,
      NULL,
      NULL,
      0.146375,
      0,
      1.561318,
      0,
      0,
      0,
      0.441629,
      0.519660,
      1.752433,
      1.813458,
      0.711989,
      0.839484,
      0,
      0.405861,
      1,
      0,
      NULL,
      0,
      0.341625,
      1,
      1.389680,
      0,
      0.031745,
      0.377671,
      1.367941,
      1,
      1.978549,
      2,
      3,
      1,
      1.673977,
      1,
      NULL,
      0,
      3,
      4.358875,
      NULL,
      4,
      1.999800,
      5.973767,
      9.178514,
      7.984207,
      2.220119,
      1,
      2.497589,
      0.867469,
      NULL,
      NULL,
      4.515435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.437219,
      1.297804,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.783080,
      NULL,
      5,
      2.334797,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829270,
      NULL,
      NULL,
      NULL,
      6,
      0,
      7,
      1,
      NULL,
      NULL,
      0,
      7.750134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.496107,
      1,
      NULL,
      2.602514,
      1,
      0.219005,
      0,
      1.226525,
      0.134285,
      1,
      3.507342,
      NULL,
      0,
      1.893441,
      0.781704,
      NULL,
      0,
      1.634713,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '33201',
      '',
      '',
      1.106545,
      NULL,
      '',
      '',
      1,
      '0210',
      '01301',
      NULL,
      1,
      4.392004,
      2.238516,
      2.710631,
      0.128058,
      7,
      3,
      1,
      3.708383);
commit;
end;
/


