set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '423',
      '31143131',
      54,
      2,
      NULL,
      63,
      0,
      0.543571,
      0,
      NULL,
      NULL,
      ' 7- 0-1984',
      49.614841,
      39,
      1.791820,
      NULL,
      1.061023,
      NULL,
      NULL,
      NULL,
      1.614357,
      1,
      0,
      1,
      NULL,
      0,
      3,
      1.658607,
      0.933236,
      0,
      1,
      1.515096,
      0.845565,
      0.954651,
      NULL,
      0.804243,
      0,
      0.603201,
      0,
      0,
      5.189785,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.585087,
      1,
      0,
      2,
      1.262521,
      NULL,
      NULL,
      0,
      NULL,
      2.795042,
      1,
      0,
      NULL,
      0.140817,
      2.931558,
      3.262314,
      0.539215,
      0,
      0,
      3,
      0.516105,
      4,
      NULL,
      0,
      0,
      1,
      1.131934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.616569,
      0,
      1.701766,
      0,
      1.042470,
      1,
      1.553822,
      NULL,
      0.078841,
      1.758099,
      NULL,
      1,
      NULL,
      NULL,
      1.115712,
      0,
      0,
      1.687659,
      NULL,
      0.734333,
      0,
      1.659199,
      0,
      NULL,
      1,
      NULL,
      0.472669,
      0.891942,
      2,
      5.597338,
      0,
      5.328207,
      1,
      0,
      0.914165,
      3.249167,
      7.792875,
      4,
      0.996224,
      6.381324,
      4,
      NULL,
      1.971662,
      4,
      4.599819,
      NULL,
      1.319081,
      0.949993,
      NULL,
      NULL,
      1,
      0.600260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.845954,
      NULL,
      7,
      3,
      0.235283,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.704956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.850382,
      7.827319,
      3,
      1,
      NULL,
      6,
      0,
      NULL,
      NULL,
      0.831058,
      4.858722,
      0.983306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.949940,
      2.989912,
      1,
      0,
      1.644028,
      NULL,
      1.420942,
      0,
      2.986856,
      NULL,
      1,
      1.985166,
      0,
      1,
      1.244475,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.741648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.482862,
      '00242',
      '',
      '',
      0.246688,
      '',
      '',
      NULL,
      NULL,
      '1122',
      NULL,
      NULL,
      NULL,
      NULL,
      0.207140,
      2.456304,
      3,
      0.640359,
      2,
      0.305077,
      1.049290);
commit;
end;
/


