set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2240',
      '43240044',
      79,
      49,
      '2234031',
      66.436265,
      NULL,
      1.855700,
      2,
      '444433',
      2.380485,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      1.681836,
      3.301930,
      1.777129,
      0,
      0.209054,
      0.154291,
      3,
      0,
      1,
      1.162471,
      0.025011,
      NULL,
      NULL,
      1.216288,
      1.627970,
      NULL,
      NULL,
      1.519384,
      0.506801,
      1,
      1,
      NULL,
      2.539022,
      0,
      NULL,
      0.142454,
      1.346713,
      0,
      NULL,
      NULL,
      0.331754,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.108009,
      1.575322,
      3.457109,
      1.606982,
      0,
      3,
      0.362350,
      0,
      NULL,
      0.489899,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.298045,
      NULL,
      5,
      1.278143,
      3,
      0.190206,
      NULL,
      1,
      0.199086,
      NULL,
      1.119800,
      0.770482,
      1.384944,
      0.212586,
      1,
      0.530560,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.993478,
      0.606536,
      NULL,
      1,
      0.541445,
      NULL,
      5.508333,
      0.812883,
      1,
      0.628988,
      NULL,
      1.761806,
      1.822522,
      0.233733,
      NULL,
      2.194169,
      5.232255,
      4,
      5.853670,
      1.778971,
      NULL,
      0.456337,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      2.287407,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106741,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.284137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.200313,
      NULL,
      NULL,
      2.372147,
      1.273765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.237072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      8,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.177793,
      0,
      1,
      0.854871,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.960324,
      1.753369,
      0,
      1.329344,
      0.016481,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.540518,
      '13443',
      '',
      '',
      1.924745,
      '',
      '',
      '',
      0,
      '0443',
      '12123',
      NULL,
      NULL,
      NULL,
      2.209322,
      3,
      NULL,
      5,
      0.708229,
      2.415625,
      3.693146);
commit;
end;
/


