set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0444',
      '32410020',
      16,
      NULL,
      NULL,
      111,
      5,
      1,
      NULL,
      '011234',
      NULL,
      NULL,
      38.788580,
      8,
      1,
      NULL,
      1,
      NULL,
      0.722723,
      0,
      1.922697,
      0.703844,
      3,
      0,
      0.751771,
      1.744345,
      1.395982,
      0,
      0.628908,
      1,
      1.679324,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1.570291,
      6,
      1,
      NULL,
      0.114266,
      1,
      1.922808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0.369128,
      0,
      1,
      0,
      0.850283,
      0.040248,
      1.977339,
      1.818227,
      NULL,
      0.054363,
      1,
      0.941115,
      2.711574,
      1,
      2,
      1.587965,
      0.438879,
      1.840012,
      2,
      0,
      1,
      4.731742,
      NULL,
      2,
      0,
      0.562613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596201,
      NULL,
      3.076008,
      0.198921,
      4,
      0,
      1.940303,
      1.727802,
      NULL,
      1.973044,
      1,
      0,
      0.155140,
      1,
      0.540751,
      1,
      0.549418,
      0,
      0.309443,
      NULL,
      1,
      0.260816,
      1,
      0.032487,
      NULL,
      1,
      NULL,
      0.204074,
      4,
      NULL,
      NULL,
      4,
      1.467789,
      3.020537,
      3,
      NULL,
      0,
      5.875868,
      NULL,
      3,
      9.945946,
      3,
      5.515022,
      2.105032,
      6.885514,
      1.644088,
      1.381098,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.528374,
      1.552105,
      1,
      0,
      1.740487,
      0.279542,
      1.950246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1.977296,
      1,
      0.462317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.574424,
      9.639947,
      4,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1.846801,
      3.252307,
      1.630801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884007,
      1,
      0.708599,
      0,
      0,
      NULL,
      2,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      0.504288,
      1.447884,
      0.442052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '13011',
      '',
      '',
      0,
      '',
      '',
      '',
      6.085917,
      '3123',
      '12232',
      NULL,
      4,
      0.711234,
      1,
      2.241161,
      2.088742,
      0,
      3.487134,
      3.617707,
      2.710444);
commit;
end;
/


