set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9508761';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3044',
      '24442013',
      62,
      1.087973,
      '1310011',
      NULL,
      NULL,
      NULL,
      2,
      '231323',
      5,
      ' 4-22-2000',
      9.883425,
      34.204301,
      NULL,
      NULL,
      0.630769,
      NULL,
      0.443596,
      NULL,
      0,
      0,
      1,
      1,
      0.094257,
      0.696439,
      0,
      0.044976,
      NULL,
      NULL,
      NULL,
      1,
      5.142888,
      NULL,
      0,
      0,
      1,
      0.161725,
      4.550198,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.532340,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3.928155,
      NULL,
      1.180295,
      2.613262,
      1,
      NULL,
      0.403730,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.194516,
      3,
      0,
      1,
      1,
      4.459294,
      3.482323,
      5,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.054225,
      1.587854,
      NULL,
      0.473643,
      5.122645,
      0,
      0.679168,
      NULL,
      1.184021,
      1,
      0.400547,
      1.080131,
      1,
      1.985411,
      1.459039,
      NULL,
      NULL,
      0.401312,
      1.923948,
      NULL,
      1.292363,
      NULL,
      0,
      0,
      0,
      0.288557,
      1.526550,
      NULL,
      4.119182,
      NULL,
      NULL,
      0,
      3.001448,
      1,
      5.818443,
      NULL,
      0,
      5,
      2,
      NULL,
      NULL,
      3.228652,
      NULL,
      9,
      NULL,
      1.921966,
      5.664767,
      0.162110,
      3.074852,
      1,
      1.249924,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926595,
      NULL,
      0,
      1,
      1.693703,
      0.686022,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.768066,
      NULL,
      NULL,
      1.302410,
      NULL,
      1,
      3,
      1.033833,
      1,
      1.627715,
      1.664341,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6,
      6.297921,
      0,
      0,
      1,
      NULL,
      NULL,
      0.907744,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.932361,
      1,
      0.300840,
      NULL,
      0.425024,
      1,
      2,
      1,
      3,
      1.690700,
      NULL,
      1.654351,
      0,
      0,
      0.955419,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.156088,
      '23310',
      '',
      '',
      0.643156,
      '',
      NULL,
      '',
      4,
      '2043',
      '34122',
      '0123',
      0.700338,
      3,
      0,
      0.441823,
      3,
      NULL,
      0.116018,
      2.941694,
      2.783492);
commit;
end;
/


