set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8229218';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1330',
      '12202344',
      71.976108,
      36.199666,
      '1100112',
      119.325895,
      4,
      2,
      3,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.239915,
      1.788621,
      3,
      0,
      1.514498,
      NULL,
      1,
      1,
      1,
      0.664017,
      NULL,
      1.335710,
      1.868361,
      1,
      0,
      1.077069,
      0,
      1,
      NULL,
      1,
      0.611590,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.105692,
      0.432462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.615576,
      0,
      0.456037,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.311394,
      2.452719,
      NULL,
      NULL,
      0,
      1,
      0.388217,
      1,
      NULL,
      0.128077,
      NULL,
      0.744513,
      1,
      NULL,
      0,
      1.484461,
      NULL,
      0,
      0,
      NULL,
      0.373325,
      NULL,
      NULL,
      0,
      0.664022,
      0.483399,
      5,
      0,
      3.175989,
      2.285932,
      0,
      4.385515,
      5.561927,
      0.798939,
      3,
      1,
      NULL,
      9.356473,
      0,
      0.685030,
      NULL,
      1.469113,
      4.814924,
      6.224200,
      5,
      0.974372,
      NULL,
      0.062222,
      3.131792,
      0,
      0.532566,
      5.179312,
      1.806331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385411,
      NULL,
      2,
      NULL,
      1.497530,
      1,
      7,
      0.880135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.653698,
      NULL,
      5.126516,
      1,
      2.112694,
      NULL,
      3,
      NULL,
      0.437917,
      0.165483,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908117,
      1,
      3,
      2.114932,
      1.301467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830935,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.464182,
      1.322605,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.534238,
      0.146367,
      0.420296,
      NULL,
      1.438362,
      1.002379,
      NULL,
      0.941791,
      1.252978,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '2444',
      '',
      NULL,
      NULL,
      '12012',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      5,
      2,
      2.435918,
      NULL,
      2,
      NULL,
      2,
      5.336457,
      1.956652);
commit;
end;
/


