set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '3',
      NULL,
      NULL,
      '2001101',
      30.468801,
      3,
      3.622941,
      3,
      '214131',
      0,
      ' 9-14-1986',
      53,
      NULL,
      NULL,
      NULL,
      3.358534,
      0,
      1,
      0.130673,
      0,
      2.243771,
      1,
      NULL,
      1,
      1.162226,
      0,
      0.257971,
      0,
      1.238391,
      0.405698,
      1.478286,
      0.030907,
      1.407225,
      2.736803,
      1.748747,
      1.195630,
      1,
      1.839545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.891117,
      0,
      8.446792,
      NULL,
      0.516358,
      0,
      0.613050,
      0.956177,
      1.068564,
      1.802392,
      NULL,
      1,
      NULL,
      0.049116,
      NULL,
      NULL,
      NULL,
      0,
      0.985113,
      0.666567,
      NULL,
      1,
      0.901470,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729475,
      NULL,
      NULL,
      5,
      1.117647,
      NULL,
      0.170946,
      NULL,
      NULL,
      1.555796,
      0.241190,
      NULL,
      3,
      3.354149,
      NULL,
      0.608826,
      1,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      1.583728,
      0.632862,
      5.993002,
      1,
      NULL,
      0,
      2.437985,
      1,
      0.293466,
      NULL,
      0,
      0,
      2,
      0.117223,
      0,
      5.446875,
      2,
      5,
      6.735583,
      NULL,
      0,
      1,
      6,
      NULL,
      0,
      2.579652,
      0,
      NULL,
      NULL,
      7,
      0.683188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516200,
      5.132516,
      0,
      1,
      1,
      1.817674,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      6,
      2.578187,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.371763,
      0.320081,
      1.691372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.615140,
      NULL,
      2.997457,
      1.362937,
      3.199849,
      1,
      2.785631,
      2.540185,
      1,
      2.283313,
      NULL,
      1,
      1,
      0,
      0,
      1.434544,
      1.052777,
      1,
      1,
      0.669889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.852510,
      '33302',
      '14301',
      '23431',
      0.417103,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


