set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '0222243',
      51.260405,
      6,
      2.154965,
      2,
      '130032',
      3,
      ' 5-29-1998',
      20.582161,
      NULL,
      0,
      NULL,
      2,
      1.539528,
      0.048797,
      NULL,
      NULL,
      2.405475,
      NULL,
      1,
      NULL,
      1,
      1.604104,
      1,
      1.538312,
      1.830536,
      0,
      NULL,
      NULL,
      1.461210,
      1.170760,
      1,
      1.928737,
      0.667882,
      1.288756,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889193,
      1.126591,
      0.650849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922372,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1.793343,
      1.476720,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5.482892,
      NULL,
      0,
      0.637802,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      4.723653,
      1.288503,
      NULL,
      1.422282,
      NULL,
      NULL,
      NULL,
      0.192023,
      0.341735,
      1,
      0,
      0,
      0.867347,
      1.063240,
      1.590491,
      0,
      1.836202,
      0.945595,
      NULL,
      0,
      0,
      1.552177,
      0,
      1,
      6,
      NULL,
      3,
      2,
      NULL,
      8.576346,
      NULL,
      0.335512,
      0,
      2.148660,
      5,
      1,
      NULL,
      NULL,
      1.877253,
      1.582703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336264,
      2,
      NULL,
      NULL,
      1.813861,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.153615,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.181872,
      3.377948,
      1.197519,
      1,
      0,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.646587,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.561386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.175497,
      1,
      0.488746,
      0.125892,
      1.577919,
      0.072544,
      1,
      0.587379,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.725748,
      1.969203,
      NULL,
      0.924597,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '44443',
      '22134',
      '10310',
      1.773053,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


