set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '204',
      '33',
      14.525420,
      14.435451,
      '0433413',
      33,
      2,
      NULL,
      0,
      '210400',
      NULL,
      ' 2- 8-1986',
      37,
      100,
      NULL,
      NULL,
      8,
      0.479213,
      NULL,
      1,
      NULL,
      3.426933,
      0.195322,
      1,
      2.939855,
      1.584379,
      NULL,
      NULL,
      0.878217,
      2.512528,
      6.656287,
      0,
      10.665890,
      0.065785,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5.372224,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      3.222145,
      1,
      2,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.100774,
      1.026841,
      NULL,
      3.370986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.969050,
      0.639630,
      1,
      1,
      2,
      0,
      0.206078,
      NULL,
      NULL,
      1.029373,
      NULL,
      NULL,
      0.779880,
      0.581171,
      7.458009,
      1.299007,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0,
      NULL,
      0,
      3.452592,
      0,
      0,
      0,
      0.247634,
      NULL,
      NULL,
      0,
      NULL,
      1.618811,
      4.499341,
      5,
      NULL,
      1,
      1,
      5.574066,
      NULL,
      0.676144,
      0.648176,
      0.699250,
      NULL,
      3.875014,
      2,
      0,
      2.741650,
      4,
      4.296022,
      7.400519,
      1,
      5,
      0.354482,
      3.821361,
      1.392477,
      1,
      2,
      NULL,
      NULL,
      0,
      7.561793,
      1.426250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588154,
      0,
      1,
      NULL,
      NULL,
      1,
      0.220461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.734498,
      1,
      3.265016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.477946,
      1.719913,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.591955,
      1.847228,
      1,
      NULL,
      3,
      3.094323,
      1,
      3,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0.572972,
      0.041921,
      1.783416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.207173,
      '31244',
      NULL,
      '',
      0.694411,
      '',
      '',
      '',
      0.089079,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


