set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '201',
      '43',
      29.675102,
      22,
      '2331300',
      119.498646,
      4,
      3,
      0,
      '323012',
      4,
      NULL,
      7.526777,
      38,
      1,
      NULL,
      NULL,
      1.688985,
      0.004799,
      1.937741,
      NULL,
      3,
      NULL,
      1,
      0.836782,
      0,
      1.247930,
      0,
      1.991721,
      4,
      1,
      1.415096,
      NULL,
      0.373226,
      NULL,
      NULL,
      1,
      1,
      6.684047,
      0,
      0,
      1.966822,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.027293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.859193,
      1.817245,
      1.010109,
      3.383979,
      1,
      NULL,
      0.805451,
      0.667882,
      NULL,
      NULL,
      1.702667,
      NULL,
      NULL,
      1,
      NULL,
      0.802312,
      0,
      0.508759,
      0.088376,
      4,
      0.945440,
      0.521083,
      NULL,
      4.333607,
      1.204033,
      0.630350,
      0.872939,
      1,
      NULL,
      NULL,
      0,
      1.455399,
      NULL,
      0,
      NULL,
      1,
      1.454559,
      0.866419,
      NULL,
      1,
      0.665340,
      1.936412,
      1.754871,
      1,
      NULL,
      NULL,
      0.112691,
      NULL,
      0.416118,
      1,
      4.284379,
      5,
      1.331053,
      5,
      NULL,
      4,
      NULL,
      7,
      1.023713,
      5.764731,
      3,
      1,
      0,
      0,
      9.312551,
      0.045988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.492856,
      NULL,
      0,
      1.852383,
      1.899425,
      1,
      0.881184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223771,
      NULL,
      NULL,
      NULL,
      NULL,
      0.039868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.707654,
      3,
      1.867176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.171760,
      NULL,
      1.985855,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.372315,
      1.888399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.303984,
      0,
      0.907962,
      1,
      2,
      NULL,
      1.611938,
      1,
      2.532568,
      NULL,
      1,
      1.444947,
      NULL,
      1,
      0,
      1.574870,
      0.527169,
      1.706719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '11212',
      '44303',
      '',
      0,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      '',
      2,
      NULL,
      0.744395,
      2,
      1,
      NULL,
      3,
      1,
      NULL);
commit;
end;
/


