set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      '12230301',
      16.469174,
      14,
      '0313014',
      222.777645,
      3,
      3.627816,
      3,
      '002132',
      5,
      ' 0-24-1986',
      16,
      52,
      0.659729,
      NULL,
      7.140227,
      0.579512,
      1.636032,
      0.810781,
      1.273915,
      1,
      1.635052,
      0,
      2.979818,
      1,
      7.368757,
      NULL,
      NULL,
      NULL,
      8.390261,
      2,
      0.314577,
      1,
      1,
      1.263118,
      NULL,
      1.644349,
      NULL,
      NULL,
      1.334928,
      NULL,
      NULL,
      0.815583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.558974,
      0.953121,
      NULL,
      1.572712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.096413,
      7.847696,
      1.637260,
      0.843678,
      0,
      1,
      1,
      1.325225,
      NULL,
      NULL,
      0.119638,
      NULL,
      NULL,
      1,
      3,
      0,
      2.570678,
      0,
      NULL,
      0.149324,
      NULL,
      0.342888,
      NULL,
      3.108095,
      1.395336,
      1.935048,
      3.926875,
      0.704659,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0.618605,
      1,
      7,
      NULL,
      0.447577,
      0.334541,
      2.501154,
      0,
      7,
      0,
      0,
      0.895653,
      0.603006,
      1,
      4,
      5,
      2.958344,
      2.381749,
      3.503082,
      3,
      3.123051,
      1,
      0,
      NULL,
      NULL,
      3,
      4.603477,
      4,
      NULL,
      NULL,
      1.598511,
      2.838815,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.118848,
      1.520524,
      2,
      1,
      0.315734,
      1,
      1.224218,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199656,
      0.611366,
      3.255123,
      0.693035,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.761542,
      0,
      2,
      2,
      0.962538,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.298118,
      1,
      NULL,
      2.274190,
      0,
      3,
      0.135841,
      NULL,
      1.409470,
      NULL,
      NULL,
      0,
      0.342399,
      0,
      NULL,
      0.107262,
      1.818835,
      1,
      0,
      0.339126,
      1.325432,
      1.139401,
      0,
      0.831031,
      NULL,
      0.645643,
      NULL,
      2.514236,
      1,
      0.043210,
      1,
      0.787032,
      1,
      1.105383,
      NULL,
      NULL,
      3.400002,
      0,
      NULL,
      0.629004,
      NULL,
      0.769828,
      1.021140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.553587,
      '00343',
      NULL,
      NULL,
      1,
      '',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      5,
      4.277409,
      0,
      NULL,
      NULL,
      4.845371,
      1.024463,
      1,
      NULL);
commit;
end;
/


