set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '041',
      '02012022',
      9,
      50,
      NULL,
      49,
      3,
      0.932763,
      3,
      '330330',
      NULL,
      ' 5-25-2000',
      7,
      12,
      0.637832,
      NULL,
      1,
      1.976083,
      1.575821,
      1.055324,
      NULL,
      0,
      1.577696,
      NULL,
      1.257245,
      0.401680,
      3.970103,
      NULL,
      0,
      8.867781,
      5,
      0,
      11.534511,
      2.805918,
      1.365165,
      2,
      NULL,
      2,
      0.671864,
      2,
      4,
      4.929646,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527505,
      9,
      8.482897,
      3,
      2,
      NULL,
      0.938176,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.871165,
      1.783741,
      NULL,
      NULL,
      0.343266,
      5.030828,
      1.714699,
      1,
      3,
      NULL,
      NULL,
      4,
      0,
      1.357572,
      1,
      1,
      1,
      1,
      NULL,
      0,
      0,
      4,
      NULL,
      NULL,
      1,
      5,
      0.728234,
      NULL,
      NULL,
      0.633027,
      0,
      0,
      NULL,
      1.106859,
      6,
      0.599842,
      2,
      4,
      6.019894,
      NULL,
      5.926265,
      3,
      2.915484,
      5.446735,
      1,
      10.994627,
      5.549962,
      0,
      0,
      0,
      0.427192,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      4.755458,
      1.358519,
      0.321192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415862,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.791732,
      3.455292,
      1,
      NULL,
      NULL,
      NULL,
      7.759179,
      1,
      1.669918,
      2.251372,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.631687,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.400062,
      2.173178,
      0.655982,
      NULL,
      3.717526,
      NULL,
      0,
      2,
      3.047691,
      NULL,
      1,
      1.758934,
      0.129785,
      0,
      1.489531,
      1,
      1.998856,
      1.524478,
      1,
      1.627693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.251750,
      1.615957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.049031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531954,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069274,
      1,
      0,
      NULL,
      NULL,
      0.186154,
      1.761197,
      1,
      5.195142,
      '11343',
      '43444',
      '',
      0.266078,
      '',
      '',
      '',
      0.306421,
      '',
      '',
      '',
      0,
      3.780154,
      2,
      2.824781,
      0,
      NULL,
      NULL,
      2.861782,
      3.672062);
commit;
end;
/


