set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '431',
      '41334341',
      51,
      20,
      NULL,
      NULL,
      0,
      1.163321,
      0,
      NULL,
      6.161554,
      ' 9- 9-1997',
      12.384683,
      28.789730,
      0,
      NULL,
      8,
      1,
      3,
      0,
      NULL,
      1.970538,
      1.667501,
      0,
      1.851891,
      0,
      4.169726,
      0.889190,
      0.214016,
      3,
      0,
      2.208276,
      5,
      0.340376,
      NULL,
      1,
      2,
      1,
      6.877282,
      NULL,
      NULL,
      0.900199,
      2.577332,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.460680,
      3.729843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.137772,
      1,
      5.005219,
      NULL,
      1,
      0,
      2,
      1.853985,
      0.665477,
      1.546129,
      5.512103,
      0.089822,
      NULL,
      1.914239,
      1,
      1.708715,
      0.494951,
      0.726154,
      NULL,
      NULL,
      0,
      0.517573,
      0,
      1,
      0.358849,
      1,
      0.686872,
      0,
      0.728705,
      0,
      NULL,
      0,
      NULL,
      0.413950,
      0.409096,
      1.277959,
      0.833117,
      6.337263,
      1,
      3,
      3.199568,
      0.919793,
      NULL,
      8,
      5.849849,
      2,
      NULL,
      7,
      2,
      0,
      0.773874,
      2.334730,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152675,
      1,
      1,
      1,
      1.575845,
      1,
      0.598145,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.350855,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4,
      1.988076,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.433214,
      0.257476,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.645521,
      3,
      0.230803,
      0.609085,
      0,
      3,
      1.696883,
      0.246294,
      NULL,
      1,
      1,
      0,
      1.269788,
      1.904498,
      1.345508,
      0,
      1.903839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.085377,
      '40044',
      '13334',
      '',
      0.583449,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      5.143356,
      0.893951,
      3.510543,
      1.082595,
      5,
      3.883350,
      0,
      NULL,
      2);
commit;
end;
/


