set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '042',
      '33231010',
      NULL,
      NULL,
      NULL,
      6.802953,
      NULL,
      0.387439,
      1,
      NULL,
      NULL,
      ' 0-11-1990',
      NULL,
      11.481496,
      0.613439,
      NULL,
      16.583602,
      0.497512,
      NULL,
      0,
      1.239832,
      0,
      1.225370,
      1,
      0,
      0,
      2.195071,
      0.523189,
      NULL,
      1,
      0,
      0,
      0,
      0.759641,
      0.124094,
      1.229089,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3.642297,
      1,
      0.181645,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.065443,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2.206153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.854288,
      1.884283,
      4,
      4,
      0,
      1.063480,
      4.771799,
      0.684041,
      NULL,
      7.948771,
      NULL,
      7,
      NULL,
      NULL,
      1,
      1.302104,
      0.964848,
      NULL,
      0.730371,
      0,
      5,
      0.963356,
      2.460880,
      0.940254,
      3,
      1.872104,
      NULL,
      0.914879,
      0,
      1.201924,
      NULL,
      NULL,
      1,
      0.777037,
      0,
      5,
      NULL,
      0.165460,
      NULL,
      1,
      3,
      7.160303,
      2,
      4,
      0,
      1.702198,
      2.830512,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0.210663,
      0.494403,
      0,
      1.071192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.029633,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.312595,
      0.543588,
      1.671603,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.450681,
      0.732314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.214869,
      NULL,
      NULL,
      1,
      1.038960,
      1.503341,
      3.818757,
      1.719685,
      1,
      NULL,
      0.582351,
      1.583537,
      0,
      0.098754,
      1,
      1,
      NULL,
      0.465776,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '14211',
      '33010',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      0,
      NULL,
      1.679886,
      NULL,
      0.738858,
      3,
      NULL,
      2.110680);
commit;
end;
/


