set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '142',
      '11214033',
      63,
      10.943323,
      '1133401',
      78,
      3,
      2.614913,
      NULL,
      '332240',
      5.010399,
      NULL,
      17,
      NULL,
      1.841554,
      NULL,
      NULL,
      0,
      1.531706,
      0.368901,
      0,
      1,
      1,
      0,
      2,
      0.887062,
      NULL,
      1,
      1.429136,
      0.248561,
      3.548646,
      1,
      6.297321,
      0.182909,
      3,
      1.914564,
      1.589797,
      0,
      NULL,
      0,
      2,
      3,
      0.626042,
      0.732924,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.897639,
      NULL,
      NULL,
      1.501758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.413574,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.105526,
      2.888959,
      2,
      1.104666,
      2,
      5,
      5.462975,
      NULL,
      2,
      5,
      1,
      3.871667,
      0,
      6,
      NULL,
      0,
      1.613225,
      1,
      NULL,
      NULL,
      0.673534,
      0,
      2.212682,
      0,
      0.677296,
      3.064953,
      1,
      0.075924,
      4,
      1.820635,
      0,
      0,
      4,
      0.492550,
      1.597842,
      1.723101,
      5,
      2.998268,
      7,
      6.972716,
      5.460892,
      7.963669,
      NULL,
      3,
      2,
      5,
      2.642050,
      1.400962,
      2,
      NULL,
      1,
      0,
      0.308730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883927,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      0.739432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.852350,
      NULL,
      3.949738,
      5.344855,
      1.081369,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.524983,
      2.736579,
      0,
      2,
      2,
      1,
      1.266820,
      1,
      0,
      1.075757,
      1.370194,
      NULL,
      1.270388,
      1,
      NULL,
      0,
      NULL,
      0.111241,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.348692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '00313',
      '12020',
      NULL,
      0.175416,
      '',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      4,
      3,
      3.487770,
      2.888560,
      1,
      NULL,
      NULL,
      3,
      0.919883);
commit;
end;
/


