set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '342',
      '14240043',
      NULL,
      NULL,
      '4310032',
      301,
      3,
      2.049682,
      2,
      '130130',
      2,
      ' 3-15-1986',
      26,
      48.864561,
      0,
      NULL,
      16.833633,
      NULL,
      0,
      NULL,
      0,
      0.808110,
      0,
      NULL,
      0.448408,
      1,
      1.519542,
      1.659685,
      0.041751,
      0,
      1,
      1,
      2,
      1.444135,
      1.618213,
      0,
      0.469062,
      1.720969,
      5.610315,
      0,
      1.627583,
      2,
      2,
      1.286698,
      NULL,
      NULL,
      0.017116,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.516755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257729,
      1.987303,
      1.595658,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378853,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.887650,
      1,
      1.275945,
      1,
      0.630731,
      2,
      NULL,
      1,
      NULL,
      1,
      0.671064,
      NULL,
      1,
      7.432817,
      NULL,
      0,
      5.369223,
      0.736200,
      3,
      0.874414,
      3.668246,
      2,
      3.228958,
      NULL,
      2,
      6,
      NULL,
      1.914992,
      4,
      5,
      7,
      9,
      7.815550,
      3,
      9,
      1.991007,
      3.868861,
      7.386618,
      4.826577,
      0,
      0.407722,
      NULL,
      NULL,
      6.051829,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.169383,
      NULL,
      0,
      1,
      1,
      1.975558,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.864712,
      1.946792,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2.108540,
      1.941025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242110,
      3.552542,
      NULL,
      NULL,
      3,
      0.289115,
      0.430874,
      3.187542,
      0,
      1.302804,
      2.842081,
      0,
      1.562426,
      1.927159,
      1.648571,
      0,
      1,
      1,
      1.884237,
      1.318742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.992022,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.666754,
      '41420',
      '03311',
      '',
      0.612531,
      '',
      '',
      '',
      1.663388,
      '',
      '',
      '',
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      0.026253,
      0.161287,
      3.139226);
commit;
end;
/


