set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2123',
      '30312013',
      61.329626,
      85,
      '3324134',
      85,
      0,
      3.112640,
      3,
      '001303',
      2,
      '11- 5-1987',
      22.064788,
      17.099809,
      1.522136,
      NULL,
      8.431294,
      NULL,
      1,
      NULL,
      1.676439,
      2.790723,
      1,
      1.426771,
      3.253855,
      NULL,
      5,
      1.914202,
      1.652507,
      1,
      NULL,
      0.849521,
      NULL,
      1,
      0,
      NULL,
      0,
      1.012301,
      0,
      1,
      2.661736,
      0.773654,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.148335,
      0.644919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.231269,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.474137,
      0.098781,
      0.521175,
      0.996888,
      0,
      0,
      1,
      NULL,
      NULL,
      1.780188,
      1,
      1,
      0,
      0.282857,
      1.791291,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      2.726406,
      1.063584,
      0,
      0.754278,
      5.262244,
      NULL,
      4,
      1.559802,
      1.185537,
      2.250239,
      5.718159,
      NULL,
      NULL,
      NULL,
      1.079970,
      0.647875,
      8,
      7.487254,
      2,
      3.368084,
      7,
      5,
      5.479272,
      NULL,
      NULL,
      5,
      1.039721,
      NULL,
      NULL,
      2.794720,
      1.414400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496218,
      0,
      NULL,
      1,
      0.363211,
      0.426727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848821,
      NULL,
      NULL,
      NULL,
      NULL,
      0.897717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.441315,
      3.524993,
      NULL,
      NULL,
      NULL,
      NULL,
      1.367910,
      0,
      1,
      4,
      0.840756,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.967774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867073,
      2,
      0,
      1.290689,
      0,
      0.231872,
      3.951320,
      0.306807,
      0.863340,
      0.570850,
      1.998999,
      NULL,
      0.334051,
      0,
      0.234763,
      0,
      0.404886,
      0.309979,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.341607,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '44113',
      '41012',
      '',
      0,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.525688,
      3,
      2.932097);
commit;
end;
/


