set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8727701';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421',
      '23111103',
      NULL,
      93,
      '1320320',
      273.442776,
      NULL,
      3.207417,
      3,
      '430001',
      3,
      ' 2- 9-2001',
      7.878099,
      9,
      NULL,
      NULL,
      7.964401,
      1.651332,
      2.686695,
      NULL,
      1,
      1,
      NULL,
      0.063145,
      3,
      0.896213,
      5,
      0.194365,
      NULL,
      1,
      0,
      NULL,
      0.259386,
      0.428203,
      NULL,
      1,
      1,
      0,
      5,
      0,
      4.122798,
      1.674273,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015953,
      0.911898,
      1.925151,
      0.883702,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.072163,
      1.659442,
      0.752107,
      0,
      0,
      0,
      1,
      0,
      1.195338,
      NULL,
      NULL,
      0,
      1.145440,
      1,
      0,
      0,
      0,
      0,
      NULL,
      0.807191,
      5,
      1.507826,
      0.573499,
      0,
      0,
      4,
      1.209906,
      2,
      0.967450,
      3.791421,
      0.616048,
      5.034838,
      NULL,
      7,
      1,
      0.694284,
      3,
      6,
      4.875999,
      3.175236,
      2.338044,
      2.549286,
      1,
      4.556429,
      2.244253,
      4,
      2,
      NULL,
      NULL,
      NULL,
      4.777581,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098176,
      0,
      0,
      0,
      0.672913,
      NULL,
      0,
      1.889241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641945,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.532749,
      NULL,
      NULL,
      NULL,
      1.096712,
      1,
      1.040741,
      0,
      0,
      0,
      1.266808,
      NULL,
      NULL,
      NULL,
      0,
      0.717339,
      1.383185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.848347,
      1.128232,
      1,
      0,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.217443,
      1,
      1,
      0,
      0,
      0,
      0.370680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.850994,
      NULL,
      '12411',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      4.968843,
      2,
      0,
      1,
      NULL,
      0.827983,
      NULL,
      3,
      0.232209);
commit;
end;
/


