set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      NULL,
      NULL,
      6,
      '3221042',
      13.287950,
      NULL,
      NULL,
      NULL,
      '310330',
      0.929912,
      ' 1-20-1995',
      NULL,
      NULL,
      1.685862,
      NULL,
      0.875906,
      NULL,
      2,
      1.087421,
      1.896952,
      1.137022,
      2,
      2,
      1,
      1.550026,
      0,
      0,
      NULL,
      1,
      0.690057,
      NULL,
      0.183604,
      NULL,
      0,
      1,
      1.445317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.593081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.519992,
      0.931697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.492471,
      0,
      0,
      0,
      1.893707,
      0.048645,
      0.247363,
      1,
      0,
      0,
      1.420348,
      0.813864,
      1.007043,
      0.179607,
      1.031668,
      0,
      NULL,
      NULL,
      0.150215,
      2.833743,
      0,
      1,
      1.231422,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.673034,
      NULL,
      4.885630,
      NULL,
      3.937062,
      6.222711,
      7.899711,
      2,
      1,
      0,
      0.369033,
      0,
      NULL,
      0.647434,
      0.698293,
      NULL,
      NULL,
      4.499272,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.079543,
      0.596437,
      0.094053,
      0.320499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594702,
      NULL,
      NULL,
      NULL,
      NULL,
      1.818152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.691520,
      4.506803,
      3.590670,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.637728,
      1.274524,
      1.283932,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959112,
      1,
      0,
      1,
      0.314484,
      2,
      2,
      0.712320,
      0.197427,
      3.097092,
      0,
      0,
      0.178946,
      0,
      0.706470,
      1.634561,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.773178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.672633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751921,
      NULL,
      NULL,
      NULL,
      NULL,
      1.829368,
      NULL,
      NULL,
      NULL,
      NULL,
      3.940486,
      0.138963,
      NULL,
      NULL,
      NULL,
      0.374007,
      1,
      2,
      2.231321,
      '04303',
      '',
      '',
      0,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      3,
      2,
      5,
      NULL,
      NULL,
      2,
      1,
      NULL);
commit;
end;
/


