set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '443',
      '30210014',
      73.270448,
      40.893765,
      '2340023',
      NULL,
      NULL,
      2.387127,
      2,
      '010232',
      NULL,
      ' 7-17-1978',
      NULL,
      4.378747,
      1.689232,
      NULL,
      NULL,
      1,
      0.196334,
      0.810991,
      1,
      2,
      0.814426,
      2.250037,
      NULL,
      1,
      1.428561,
      1.605159,
      0,
      NULL,
      1.076582,
      0.316614,
      1,
      0.595979,
      1,
      0,
      1.515068,
      1.973840,
      4,
      0,
      NULL,
      5.300695,
      3.668534,
      0.920951,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439237,
      NULL,
      0.470990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775056,
      1,
      0.940754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.266468,
      1,
      1,
      0.608136,
      NULL,
      1,
      1,
      0.783720,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      1.143964,
      1,
      0.701747,
      NULL,
      NULL,
      NULL,
      4.143748,
      1.534964,
      NULL,
      NULL,
      1,
      0,
      5,
      1.193946,
      1,
      NULL,
      1.376381,
      2,
      5,
      0,
      4.053708,
      2.809357,
      4,
      NULL,
      NULL,
      1,
      2,
      5,
      2,
      0,
      NULL,
      0,
      0.566121,
      NULL,
      NULL,
      2.633088,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.851976,
      0.288810,
      0,
      1,
      1.141321,
      0.335754,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458799,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.650138,
      0.806840,
      1.369086,
      NULL,
      NULL,
      NULL,
      NULL,
      0.736285,
      NULL,
      4.641040,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.386568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831215,
      0,
      2.278914,
      1.955724,
      1.647528,
      0.628086,
      1.228369,
      3,
      1.545219,
      1.782016,
      NULL,
      0,
      NULL,
      NULL,
      1.569741,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.755867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.686383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540105,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433846,
      1,
      NULL,
      0.425005,
      1.491538,
      0,
      2,
      2.640345,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0.924277,
      '',
      NULL,
      '',
      0,
      1,
      1.220815,
      1.140338,
      NULL,
      1.286237,
      1.212256,
      1.481909,
      NULL);
commit;
end;
/


