set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0211',
      NULL,
      9,
      NULL,
      NULL,
      20,
      1,
      NULL,
      3,
      NULL,
      3.018577,
      NULL,
      NULL,
      207,
      0.308003,
      NULL,
      0,
      NULL,
      2.971425,
      NULL,
      0,
      1.004766,
      0,
      3,
      1,
      NULL,
      2.573698,
      0,
      0,
      1,
      1.560046,
      0.291008,
      1.769923,
      NULL,
      0,
      1.871053,
      NULL,
      NULL,
      0,
      0,
      2,
      3.437486,
      1.536843,
      0,
      NULL,
      NULL,
      1.873045,
      NULL,
      NULL,
      1.712140,
      1.556730,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.852740,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.108143,
      0.755511,
      0,
      0.687153,
      NULL,
      0,
      0,
      0.760865,
      1,
      1,
      0.575163,
      0.836999,
      0,
      1.929837,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      0.102588,
      0,
      0.253797,
      0,
      NULL,
      5.780058,
      1.074244,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.577423,
      3,
      NULL,
      3.166370,
      1,
      2.901458,
      1.388444,
      7,
      5.040127,
      4,
      5,
      2.626979,
      NULL,
      1.330646,
      0,
      NULL,
      NULL,
      NULL,
      8.210689,
      0.497566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144382,
      0,
      0,
      0,
      0.938162,
      1,
      NULL,
      0.714110,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.198698,
      1,
      1.533356,
      1.970500,
      0.912739,
      0,
      0.306847,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994815,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.483631,
      0.860630,
      3.349375,
      0,
      3.424425,
      0.300656,
      0,
      NULL,
      0,
      0.551570,
      NULL,
      1.947505,
      1,
      NULL,
      0.534517,
      NULL,
      0.124283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.461255,
      1.830363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.684443,
      NULL,
      1.088180,
      1.433533,
      0.188849,
      1,
      NULL,
      '34003',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.113253,
      '',
      '',
      NULL,
      0,
      0.523997,
      0.435957,
      2,
      0.669548,
      0.071033,
      NULL,
      3.086461,
      2.132679);
commit;
end;
/


