set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3044',
      '33132333',
      23,
      NULL,
      '2032421',
      NULL,
      4,
      3,
      1,
      '223044',
      1,
      NULL,
      7,
      175,
      0,
      NULL,
      1.971774,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.927829,
      0.679578,
      0,
      5.153429,
      0.758667,
      0,
      2,
      NULL,
      0,
      NULL,
      1.669138,
      0,
      0.008248,
      0,
      0.613839,
      3.003121,
      0,
      2.910735,
      0.780552,
      0,
      0,
      NULL,
      NULL,
      1.604437,
      NULL,
      NULL,
      1,
      1.524111,
      0.144644,
      1.937219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204619,
      1.494814,
      1,
      0.038247,
      0.074383,
      0.911765,
      0,
      0,
      0.358897,
      NULL,
      0.947498,
      1.528060,
      0.108496,
      NULL,
      NULL,
      NULL,
      0.943993,
      NULL,
      0,
      NULL,
      1.728633,
      2.031244,
      NULL,
      1,
      0,
      0.973697,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.723213,
      2.902852,
      4.691047,
      0.282982,
      0,
      3,
      2,
      5,
      1,
      NULL,
      5,
      7,
      6,
      1.121074,
      NULL,
      0.125581,
      0.905921,
      NULL,
      NULL,
      3.719634,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000731,
      0,
      1,
      1,
      1.345146,
      1.301590,
      NULL,
      0.510165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.805508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5.716093,
      3.753138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722630,
      1.549044,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.987848,
      NULL,
      0.550318,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.527110,
      0.217586,
      1,
      1.083643,
      NULL,
      1.534113,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.070162,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.097302,
      1,
      3.408247,
      '40404',
      '',
      NULL,
      0.607130,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      3.442684);
commit;
end;
/


