set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4414',
      NULL,
      80.952201,
      33.160612,
      '2222112',
      11.345216,
      6,
      2.035892,
      0,
      NULL,
      1.804307,
      NULL,
      NULL,
      41.083509,
      0,
      NULL,
      3.727969,
      0.987597,
      1,
      1,
      0,
      1.221653,
      0.038231,
      2,
      0,
      0.046912,
      4.869032,
      0.875106,
      1.778415,
      1,
      1,
      1,
      0,
      0.112931,
      2,
      NULL,
      1,
      1.339196,
      NULL,
      NULL,
      0.429855,
      2,
      3,
      1,
      NULL,
      NULL,
      1.434780,
      NULL,
      NULL,
      0.673218,
      NULL,
      NULL,
      1.549274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.258560,
      1.075068,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      NULL,
      1.774760,
      0.222436,
      1,
      1,
      1,
      NULL,
      1.107752,
      0,
      1,
      0,
      1.091243,
      NULL,
      1.147210,
      NULL,
      NULL,
      0.692917,
      0.383569,
      NULL,
      4.616570,
      NULL,
      3.559434,
      1.883589,
      NULL,
      0,
      1,
      NULL,
      1.332522,
      1.303284,
      6.083350,
      5,
      NULL,
      5.160910,
      1.306620,
      4.702018,
      NULL,
      5.355759,
      4.390828,
      1.368895,
      0,
      NULL,
      1.339609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.828342,
      1,
      1.631602,
      1.662329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.360917,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690053,
      1.753807,
      7,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.878214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640350,
      0.314453,
      0.511617,
      0.387134,
      0,
      1.540190,
      1.920807,
      2,
      NULL,
      3,
      0.538017,
      1.470888,
      NULL,
      NULL,
      0.476725,
      NULL,
      1.679336,
      1,
      NULL,
      0.283107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.046289,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828946,
      0,
      0.988735,
      NULL,
      1,
      NULL,
      1,
      0,
      3.632329,
      '12400',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      1.449883,
      NULL,
      '',
      '',
      0.797603,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0.273593,
      3.538658,
      3);
commit;
end;
/


