set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0224',
      '13023330',
      76.758448,
      NULL,
      '3131012',
      23,
      2,
      NULL,
      1,
      '241224',
      0,
      '10- 6-1980',
      56,
      38.671738,
      1,
      NULL,
      1.181085,
      1.012994,
      1.017535,
      1,
      NULL,
      1.450686,
      1,
      NULL,
      1.031001,
      NULL,
      1,
      1,
      0,
      2,
      0.240132,
      1,
      0.364457,
      1.899721,
      0.321269,
      1,
      0.572141,
      NULL,
      3.699931,
      NULL,
      NULL,
      2.031728,
      0,
      1.885445,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.348177,
      1.950419,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582265,
      1,
      1.632886,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519981,
      NULL,
      0,
      NULL,
      0.213417,
      5.006424,
      0,
      1,
      1.631687,
      0.238322,
      0.106079,
      0,
      0.605768,
      4.842837,
      NULL,
      NULL,
      1.909348,
      0.031120,
      1.972390,
      NULL,
      1,
      5,
      NULL,
      3.131351,
      NULL,
      1.732805,
      1,
      0,
      1.254338,
      NULL,
      NULL,
      0.075372,
      1.193247,
      5.711190,
      5.364803,
      0.151906,
      8,
      3,
      9,
      NULL,
      7,
      3.179544,
      6,
      NULL,
      9,
      1,
      0.365019,
      1.626570,
      0,
      NULL,
      NULL,
      2,
      0.069854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.949901,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240212,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.432974,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658902,
      1,
      4,
      5,
      1.521623,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556154,
      1.245675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.791812,
      0.989785,
      0,
      0,
      2.709320,
      3,
      1,
      2.377718,
      0,
      0.019992,
      1.290321,
      NULL,
      1.473110,
      0,
      0,
      NULL,
      NULL,
      0,
      0.560046,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.014345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.884575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272584,
      NULL,
      NULL,
      1,
      1,
      0.105384,
      0,
      2,
      '34000',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1.688195,
      '',
      NULL,
      '',
      1.668195,
      2.740116,
      0,
      3,
      0.046645,
      0,
      3,
      1,
      0);
commit;
end;
/


