set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9885315';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2023',
      '3',
      56,
      7.376643,
      '0040433',
      17.012731,
      4,
      NULL,
      3,
      NULL,
      2.861412,
      ' 2-16-1980',
      43.675077,
      35.717467,
      0,
      NULL,
      0,
      0,
      0.163296,
      0.734176,
      1,
      NULL,
      0.137672,
      3,
      NULL,
      0,
      0.284439,
      NULL,
      NULL,
      0.516783,
      1,
      1,
      0.365457,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751062,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.341295,
      0.328952,
      0.234927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.520092,
      3,
      0.436991,
      5.292233,
      0.657342,
      1.638230,
      1.647726,
      1.578881,
      1.742028,
      0.435932,
      0,
      NULL,
      0,
      1,
      1.286637,
      NULL,
      0,
      0,
      NULL,
      0.234690,
      3,
      1.339630,
      0,
      5.736074,
      1,
      2,
      1.632564,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.491182,
      1,
      0.811707,
      5,
      4.193323,
      NULL,
      6.094923,
      NULL,
      6,
      7.390291,
      1.982288,
      NULL,
      0.376707,
      0.311273,
      NULL,
      1.750726,
      NULL,
      NULL,
      3.517053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.960990,
      1,
      2,
      0,
      NULL,
      NULL,
      0,
      0.705334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.608443,
      0,
      1,
      NULL,
      NULL,
      0.506971,
      NULL,
      NULL,
      NULL,
      1.955250,
      0,
      0.977661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187967,
      0.535934,
      NULL,
      NULL,
      0.684349,
      0.653281,
      0.162096,
      1,
      1.819223,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.233692,
      NULL,
      NULL,
      1.549296,
      1,
      1.703835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.352330,
      NULL,
      NULL,
      NULL,
      NULL,
      1.869660,
      NULL,
      NULL,
      NULL,
      NULL,
      2.342314,
      3.020255,
      1.492333,
      NULL,
      0.824780,
      1.445807,
      1.287582,
      0,
      NULL,
      '44041',
      '',
      NULL,
      1.946192,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.283855,
      2,
      1.219977,
      0,
      0,
      0,
      NULL,
      2.091380,
      0.136335);
commit;
end;
/


