set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3024',
      '23104200',
      32.993947,
      6.481281,
      '4400034',
      11.920518,
      4,
      NULL,
      0,
      NULL,
      1,
      NULL,
      27,
      4,
      NULL,
      NULL,
      3.424133,
      NULL,
      1.255752,
      1.025249,
      NULL,
      NULL,
      1,
      1.121227,
      1,
      1,
      NULL,
      0.900439,
      5,
      3,
      5.758061,
      0,
      7.080495,
      0.769298,
      4.316040,
      2,
      NULL,
      0,
      1.370404,
      0,
      NULL,
      5.955534,
      2.388337,
      0,
      NULL,
      NULL,
      0.099826,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      0.051296,
      0.380848,
      2,
      3,
      2.298622,
      0.544151,
      NULL,
      NULL,
      NULL,
      1.647186,
      0,
      1,
      1.425354,
      NULL,
      5.867655,
      1,
      1.203026,
      9,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      1.097770,
      NULL,
      NULL,
      NULL,
      0.102062,
      4.141008,
      0,
      3.971521,
      NULL,
      1,
      0,
      5.116897,
      1.607499,
      4.196289,
      NULL,
      1,
      1,
      NULL,
      1.901839,
      1,
      NULL,
      1,
      NULL,
      1.676061,
      1.371249,
      1,
      0,
      NULL,
      0.211800,
      0.419000,
      0.529995,
      NULL,
      0,
      3,
      4,
      1,
      0.455449,
      3.656263,
      4.645813,
      5.064054,
      0.882629,
      NULL,
      4,
      3.538270,
      NULL,
      0.465009,
      0,
      NULL,
      4,
      0.132296,
      6.084418,
      2.978093,
      NULL,
      NULL,
      0.581279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.596339,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.424975,
      1,
      0.321551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0.940523,
      NULL,
      NULL,
      NULL,
      2.489887,
      0,
      5,
      4,
      NULL,
      0,
      1.375650,
      NULL,
      NULL,
      NULL,
      1.467641,
      1,
      1.040193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      2.911691,
      2,
      3,
      3,
      2.021165,
      NULL,
      2.714408,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.834465,
      NULL,
      0.347474,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.617135,
      '14120',
      '',
      '',
      0,
      '',
      NULL,
      '',
      0.097740,
      '',
      '',
      '',
      2.270251,
      NULL,
      0,
      0,
      1.965801,
      NULL,
      2,
      0,
      1.981022);
commit;
end;
/


