set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0342',
      '41304301',
      75.407940,
      NULL,
      NULL,
      20,
      6,
      3,
      NULL,
      '104141',
      0,
      ' 5-24-1974',
      NULL,
      32,
      0.235988,
      NULL,
      1.235831,
      0,
      NULL,
      0,
      0.935043,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1.815151,
      4,
      1.649793,
      2.432774,
      NULL,
      5.774609,
      1.025912,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.614101,
      3.442924,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1.406655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192729,
      1.541208,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.777162,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0.613873,
      0.533200,
      0,
      0,
      NULL,
      0.184977,
      NULL,
      0,
      1.611500,
      NULL,
      NULL,
      4,
      0.965331,
      1.245230,
      NULL,
      1.288173,
      NULL,
      NULL,
      3.139477,
      NULL,
      3,
      1.253715,
      0.969749,
      0.844234,
      1.393591,
      0,
      3.861859,
      1.733789,
      NULL,
      3.210719,
      NULL,
      5,
      NULL,
      2.552041,
      0,
      NULL,
      7.670389,
      3.681627,
      3.176554,
      1.840101,
      0.453643,
      4.899622,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.441006,
      0,
      1,
      1,
      1.933410,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728339,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.082507,
      4.430038,
      0,
      5,
      NULL,
      0.773947,
      NULL,
      NULL,
      NULL,
      1,
      1.046152,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.653507,
      NULL,
      2.523189,
      2.452174,
      0,
      2.451957,
      1,
      3,
      1.311205,
      1.742559,
      0.408998,
      1.962865,
      1.564158,
      1,
      1,
      0.572149,
      NULL,
      0.194443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.022385,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      5.180102,
      NULL,
      1.610129,
      3,
      2,
      1.188089,
      NULL,
      3.910285,
      3);
commit;
end;
/


