set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12401343',
      NULL,
      55,
      '3101214',
      9,
      NULL,
      3.450166,
      NULL,
      NULL,
      NULL,
      NULL,
      41.505777,
      3,
      1,
      NULL,
      1,
      1,
      1,
      0,
      1.889438,
      NULL,
      NULL,
      1.320507,
      3.868676,
      0.938202,
      5,
      1.827841,
      1.565760,
      0.628880,
      NULL,
      0.729850,
      6,
      0.840941,
      NULL,
      NULL,
      1.825781,
      0.861781,
      NULL,
      0,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      0.647996,
      NULL,
      NULL,
      0.225913,
      1,
      NULL,
      0.383341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.858995,
      0.838618,
      0,
      5.654486,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.476404,
      NULL,
      NULL,
      1,
      1.701855,
      NULL,
      1,
      1,
      1.044405,
      1,
      0.343206,
      0,
      0.019410,
      0,
      0,
      0.056432,
      0.449217,
      0.266671,
      1,
      1,
      NULL,
      0.678926,
      NULL,
      1,
      5,
      NULL,
      3.591162,
      1,
      0.107401,
      1.394622,
      1,
      1.584238,
      NULL,
      0.558063,
      0.295687,
      NULL,
      4,
      0,
      0.079967,
      4,
      1.798303,
      NULL,
      7,
      5.745469,
      1.277643,
      7.722258,
      4.218488,
      5.389636,
      1.204748,
      3,
      1.452042,
      1,
      0,
      NULL,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      0.110646,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.261418,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.835449,
      NULL,
      0,
      1,
      0.497176,
      NULL,
      0.481506,
      NULL,
      NULL,
      NULL,
      0.504951,
      0,
      3,
      NULL,
      1.710376,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.350684,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      1,
      0.923086,
      0.994617,
      0.119179,
      0,
      0,
      NULL,
      0.204674,
      0.353507,
      1.769933,
      0.459033,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.995431,
      '32110',
      '04104',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      3,
      3.137630,
      2,
      1.390061,
      0.594506,
      NULL,
      NULL,
      3.741196);
commit;
end;
/


