set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3132',
      '20344240',
      45.279583,
      90.887679,
      '1310013',
      27,
      1,
      1.213256,
      3,
      '122413',
      2.330452,
      ' 7- 5-1998',
      24.747927,
      55,
      1.693254,
      NULL,
      NULL,
      0.866559,
      0,
      1,
      NULL,
      3,
      1,
      0,
      0.621927,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      2,
      1.465299,
      NULL,
      0,
      1,
      1,
      0,
      5,
      0,
      4.565902,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.628182,
      0,
      0.562555,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.064660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.872751,
      1.258768,
      0,
      2,
      1,
      0.274993,
      0,
      0,
      0,
      1,
      1,
      1,
      1.387937,
      1,
      0,
      NULL,
      1.740708,
      NULL,
      NULL,
      1.035920,
      0,
      0,
      0.144397,
      1.659153,
      1.943191,
      4,
      1,
      0,
      0,
      0.631652,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.199597,
      3,
      0.173442,
      4.128561,
      1.501135,
      6.605382,
      5,
      0,
      1,
      1,
      NULL,
      NULL,
      4.222641,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.230073,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262718,
      NULL,
      1,
      0.596254,
      2,
      0.932953,
      NULL,
      NULL,
      NULL,
      1.634294,
      0.750955,
      1.858089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538926,
      3.708577,
      0.045702,
      3,
      1.123400,
      1,
      0,
      3.374797,
      1.742317,
      1.471298,
      1,
      1,
      NULL,
      0,
      1.520650,
      1,
      0,
      0,
      0,
      0.257089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.848338,
      '20303',
      '43214',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.186561,
      NULL,
      '',
      '',
      3.493276,
      1.803983,
      1.804222,
      NULL,
      0,
      2.262744,
      2.901895,
      0.168144,
      NULL);
commit;
end;
/


