set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9202285';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-1-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      2,
      '230013',
      0,
      ' 6- 9-1985',
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.848333,
      3.595523,
      0.040843,
      1,
      1.926185,
      0.230799,
      3.049029,
      0.387347,
      1.845604,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      2,
      5.469149,
      3,
      NULL,
      NULL,
      1,
      1.295440,
      NULL,
      3,
      NULL,
      2.493719,
      NULL,
      NULL,
      NULL,
      1.723309,
      NULL,
      NULL,
      5,
      2.632785,
      5,
      NULL,
      1.137588,
      0,
      3,
      3,
      2,
      1,
      2,
      1,
      NULL,
      0.778867,
      1,
      0,
      2.544993,
      2.377432,
      3,
      1.571364,
      0,
      1.385877,
      2,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.286843,
      NULL,
      NULL,
      0,
      1.428553,
      5,
      NULL,
      NULL,
      1,
      4.342977,
      0.699839,
      1,
      1.788031,
      2.224834,
      1,
      0,
      3,
      0,
      1,
      NULL,
      0.587451,
      0,
      NULL,
      0,
      1,
      1.571540,
      1.470900,
      1,
      NULL,
      1.359008,
      NULL,
      2,
      1,
      2.983500,
      0,
      NULL,
      1,
      5.080029,
      0.788075,
      2.739221,
      2,
      0,
      2.282678,
      0.221535,
      5.137450,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      1,
      1.588255,
      1.039069,
      9.897142,
      0.499665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.910162,
      2,
      1,
      1,
      1.636110,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.405947,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.205250,
      1.562644,
      1.012067,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.692935,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.534711,
      0,
      2,
      1.942339,
      1.138345,
      1,
      1,
      3,
      1,
      1,
      NULL,
      1.772462,
      0.523290,
      0.483875,
      0,
      0.963602,
      1.560208,
      1.122229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.968974,
      '32013',
      '33402',
      '',
      NULL,
      '',
      '',
      '',
      0.482387,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


